/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.ability.impl;

import draylar.identity.ability.IdentityAbility;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.impl.VillagerProfessionPackets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VillagerProfessionAbility
extends IdentityAbility<Villager> {
    @Override
    public void onUse(Player player, Villager identity, Level world) {
        if (world.f_46443_) {
            return;
        }
        if (!player.m_6144_()) {
            ((ServerPlayer)player).m_5661_((Component)Component.m_237115_((String)"identity.profession.must_sneak"), true);
            return;
        }
        HitResult result = player.m_19907_(5.0, 0.0f, false);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        Optional poi = PoiTypes.m_218075_((BlockState)world.m_8055_(blockResult.m_82425_()));
        if (poi.isPresent()) {
            Holder targetPoi = (Holder)poi.get();
            ResourceLocation poiId = BuiltInRegistries.f_256941_.m_7981_((Object)((PoiType)targetPoi.m_203334_()));
            ResourceLocation worldId = player.m_9236_().m_46472_().m_135782_();
            Map<String, CompoundTag> villagerMap = ((PlayerDataProvider)player).getVillagerIdentities();
            String existingName = null;
            String existingProfession = null;
            long workstationPos = blockResult.m_82425_().m_121878_();
            for (Map.Entry<String, CompoundTag> entry : villagerMap.entrySet()) {
                CompoundTag saved = entry.getValue();
                if (!this.matchesWorkstation(saved, worldId, workstationPos)) continue;
                existingName = entry.getKey();
                existingProfession = saved.m_128461_("ProfessionId");
                break;
            }
            for (VillagerProfession profession : BuiltInRegistries.f_256735_) {
                boolean matches = false;
                ResourceLocation profIdDirect = BuiltInRegistries.f_256735_.m_7981_((Object)profession);
                if (poiId != null && poiId.equals((Object)profIdDirect)) {
                    matches = true;
                }
                try {
                    Method held = VillagerProfession.class.getMethod("heldWorkstation", new Class[0]);
                    Object value = held.invoke((Object)profession, new Object[0]);
                    if (!matches && value instanceof Holder) {
                        Holder entry = (Holder)value;
                        matches = entry.equals(targetPoi);
                    }
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method acquirable = VillagerProfession.class.getMethod("acquirableJobSite", new Class[0]);
                        Object predicate = acquirable.invoke((Object)profession, new Object[0]);
                        if (!matches && predicate instanceof Predicate) {
                            Predicate raw;
                            Predicate p = raw = (Predicate)predicate;
                            matches = p.test(targetPoi);
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        try {
                            Method acquirable = VillagerProfession.class.getMethod("acquirableWorkstation", new Class[0]);
                            Object predicate = acquirable.invoke((Object)profession, new Object[0]);
                            if (!matches && predicate instanceof Predicate) {
                                Predicate raw;
                                Predicate p = raw = (Predicate)predicate;
                                matches = p.test(targetPoi);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    // empty catch block
                }
                if (!matches) continue;
                ResourceLocation profId = BuiltInRegistries.f_256735_.m_7981_((Object)profession);
                VillagerProfessionPackets.openScreen((ServerPlayer)player, profId, blockResult.m_82425_(), worldId, existingName, existingProfession);
                break;
            }
        } else {
            ((ServerPlayer)player).m_5661_((Component)Component.m_237115_((String)"identity.profession.invalid_workstation"), true);
        }
    }

    @Override
    public Item getIcon() {
        return Items.f_42616_;
    }

    private boolean matchesWorkstation(CompoundTag tag, ResourceLocation worldId, long workstationPos) {
        if (tag == null) {
            return false;
        }
        String dim = tag.m_128461_("WorkstationDim");
        long storedPos = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
        return !dim.isEmpty() && storedPos != Long.MIN_VALUE && worldId.toString().equals(dim) && storedPos == workstationPos;
    }
}

