/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeadShotModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.HEADSHOT_MULTIPLIER.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new HeadShotJsonProperty(data.getHeadShot());
    }

    @Override
    public CacheValue<Float> initCache(ItemStack gunItem, GunData gunData) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getHeadShotMultiplier() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getHeadShotMultiplier() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
        return new CacheValue<Float>(Float.valueOf(finalBase));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getHeadShotMultiplier() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getHeadShotMultiplier() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
        float modifiedValue = ((Float)cacheProperty.getCache(ID)).floatValue();
        float modifier = modifiedValue - finalBase;
        double percent = Mth.m_14008_((double)((double)finalBase / 5.0), (double)0.0, (double)1.0);
        double modifierPercent = Mth.m_14008_((double)((double)modifier / 5.0), (double)0.0, (double)1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.head_shot";
        String positivelyString = String.format("x%.1f \u00a7a(+%.1f)", Float.valueOf(modifiedValue), Float.valueOf(modifier));
        String negativelyString = String.format("x%.1f \u00a7c(%.1f)", Float.valueOf(modifiedValue), Float.valueOf(modifier));
        String defaultString = String.format("x%.1f", Float.valueOf(modifiedValue));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="head_shot")
        @Nullable
        private Modifier headShot = null;

        @Nullable
        public Modifier getHeadShot() {
            return this.headShot;
        }
    }

    public static class HeadShotJsonProperty
    extends JsonProperty<Modifier> {
        public HeadShotJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 2.0);
                if (eval > 2.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.head_shot.increase").m_130940_(ChatFormatting.GREEN));
                } else if (eval < 2.0) {
                    this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.head_shot.decrease").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

