/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.vmlib.LuaLibrary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class ScriptManager
extends SimplePreparableReloadListener<List<Map.Entry<String, Supplier<LuaTable>>>> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ScriptLoader");
    private Globals globals;
    private final Map<String, LuaTable> scriptMap = Maps.newHashMap();
    private final FileToIdConverter filetoidconverter;
    private final List<LuaLibrary> libraries;

    public ScriptManager(FileToIdConverter converter, List<LuaLibrary> libraries) {
        this.filetoidconverter = converter;
        this.libraries = libraries;
    }

    @NotNull
    protected List<Map.Entry<String, Supplier<LuaTable>>> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.initGlobals();
        ArrayList<Map.Entry<String, Supplier<LuaTable>>> output = new ArrayList<Map.Entry<String, Supplier<LuaTable>>>();
        for (Map.Entry entry : this.filetoidconverter.m_247457_(pResourceManager).entrySet()) {
            final Map.Entry<String, Supplier<LuaTable>> wrappedEntry = this.wrapLoadingFunction((ResourceLocation)entry.getKey(), (Resource)entry.getValue());
            output.add(wrappedEntry);
            this.globals.get("package").get("preload").set(wrappedEntry.getKey(), (LuaValue)new LuaFunction(){

                public LuaValue call(LuaValue modname, LuaValue env) {
                    return (LuaValue)((Supplier)wrappedEntry.getValue()).get();
                }
            });
        }
        return output;
    }

    protected void apply(List<Map.Entry<String, Supplier<LuaTable>>> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.scriptMap.clear();
        pObject.forEach(entry -> this.scriptMap.put((String)entry.getKey(), (LuaTable)((Supplier)entry.getValue()).get()));
    }

    private Map.Entry<String, Supplier<LuaTable>> wrapLoadingFunction(ResourceLocation rawResourceLocation, final Resource resource) {
        final ResourceLocation resourceLocation = this.filetoidconverter.m_245273_(rawResourceLocation);
        final String moduleName = this.getModuleName(resourceLocation);
        return new AbstractMap.SimpleEntry<String, Supplier<LuaTable>>(moduleName, new Supplier<LuaTable>(){
            private LuaTable loaded = null;

            @Override
            public LuaTable get() {
                LuaTable luaTable;
                block9: {
                    if (this.loaded != null) {
                        return this.loaded;
                    }
                    BufferedReader reader = resource.m_215508_();
                    try {
                        LuaValue chunk = ScriptManager.this.globals.load((Reader)reader, moduleName);
                        luaTable = this.loaded = chunk.call().checktable(1);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonParseException | IOException | IllegalArgumentException | LuaError jsonparseexception) {
                            GunMod.LOGGER.warn(MARKER, "Failed to read script file: {}", (Object)resourceLocation);
                            return null;
                        }
                    }
                    ((Reader)reader).close();
                }
                return luaTable;
            }
        });
    }

    private void initGlobals() {
        this.globals = ScriptManager.secureStandardGlobals();
        if (this.libraries != null) {
            this.libraries.forEach(library -> library.install((LuaValue)this.globals));
        }
    }

    private String getModuleName(ResourceLocation resourceLocation) {
        return resourceLocation.m_135827_() + "_" + resourceLocation.m_135815_();
    }

    public LuaTable getScript(ResourceLocation id) {
        return this.scriptMap.get(this.getModuleName(id));
    }

    private static Globals secureStandardGlobals() {
        Globals globals = new Globals();
        globals.load((LuaValue)new JseBaseLib());
        globals.load((LuaValue)new PackageLib());
        globals.load((LuaValue)new Bit32Lib());
        globals.load((LuaValue)new TableLib());
        globals.load((LuaValue)new JseStringLib());
        globals.load((LuaValue)new JseMathLib());
        LoadState.install((Globals)globals);
        LuaC.install((Globals)globals);
        return globals;
    }
}

