/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.audio.OggAudioStream;
import com.tacz.guns.GunMod;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class SoundAssetsManager
extends SimplePreparableReloadListener<Map<ResourceLocation, SoundData>> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"SoundsLoader");
    private final Map<ResourceLocation, SoundData> dataMap = Maps.newHashMap();
    private final FileToIdConverter filetoidconverter = new FileToIdConverter("tacz_sounds", ".ogg");

    @NotNull
    protected Map<ResourceLocation, SoundData> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : this.filetoidconverter.m_247457_(pResourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = this.filetoidconverter.m_245273_(resourcelocation);
            try {
                InputStream stream = ((Resource)entry.getValue()).m_215507_();
                try (OggAudioStream audioStream = new OggAudioStream(stream);){
                    ByteBuffer bytebuffer = audioStream.m_83764_();
                    output.put(resourcelocation1, new SoundData(bytebuffer, audioStream.m_6206_()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read sound file: {}", (Object)resourcelocation);
                exception.printStackTrace();
            }
        }
        return output;
    }

    protected void apply(Map<ResourceLocation, SoundData> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dataMap.clear();
        this.dataMap.putAll(pObject);
    }

    public SoundData getData(ResourceLocation id) {
        return this.dataMap.get(id);
    }

    public record SoundData(ByteBuffer byteBuffer, AudioFormat audioFormat) {
    }
}

