/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.display.block.BlockDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.resource.pojo.BlockIndexPOJO;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ClientBlockIndex {
    private BedrockModel model;
    private ResourceLocation texture;
    private String name;
    private ItemTransforms transforms;
    private String tooltipKey;

    public static ClientBlockIndex getInstance(BlockIndexPOJO pojo) {
        ClientBlockIndex index = new ClientBlockIndex();
        ClientBlockIndex.checkIndex(pojo, index);
        BlockDisplay display = ClientBlockIndex.checkDisplay(pojo, index);
        ClientBlockIndex.checkModel(display, index);
        ClientBlockIndex.checkName(pojo, index);
        ClientBlockIndex.checkTransforms(display, index);
        return index;
    }

    private static void checkIndex(BlockIndexPOJO blockIndexPOJO, ClientBlockIndex index) {
        Preconditions.checkArgument((blockIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        index.tooltipKey = blockIndexPOJO.getTooltip();
    }

    private static void checkName(BlockIndexPOJO blockIndexPOJO, ClientBlockIndex index) {
        index.name = blockIndexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    private static BlockDisplay checkDisplay(BlockIndexPOJO pojo, ClientBlockIndex index) {
        ResourceLocation display = pojo.getDisplay();
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"index object missing display field");
        BlockDisplay blockDisplay = ClientAssetsManager.INSTANCE.getBlockDisplay(pojo.getDisplay());
        Preconditions.checkArgument((blockDisplay != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        return blockDisplay;
    }

    private static void checkModel(BlockDisplay display, ClientBlockIndex index) {
        ResourceLocation modelLocation = display.getModelLocation();
        Preconditions.checkArgument((modelLocation != null ? 1 : 0) != 0, (Object)"display object missing model field");
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(modelLocation);
        Preconditions.checkArgument((modelPOJO != null ? 1 : 0) != 0, (Object)"there is no corresponding model file");
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            index.model = new BedrockModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            index.model = new BedrockModel(modelPOJO, BedrockVersion.NEW);
        }
        Preconditions.checkArgument((index.model != null ? 1 : 0) != 0, (Object)"there is no model data in the model file");
        ResourceLocation textureLocation = display.getModelTexture();
        Preconditions.checkArgument((textureLocation != null ? 1 : 0) != 0, (Object)"missing default texture");
        index.texture = display.getModelTexture();
    }

    private static void checkTransforms(BlockDisplay display, ClientBlockIndex index) {
        Preconditions.checkArgument((display.getTransforms() != null ? 1 : 0) != 0, (Object)"missing transforms");
        index.transforms = display.getTransforms();
    }

    public BedrockModel getModel() {
        return this.model;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getName() {
        return this.name;
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }
}

