/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class StabilizationModule
extends BaseModule {
    private int blockCount = 0;

    public StabilizationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public void beforeProject(Projector projector) {
        this.blockCount = 0;
    }

    @Override
    public Module.ProjectAction onProject(Projector projector, BlockPos position) {
        if (projector.getTicks() % 40L == 0L) {
            Level level = projector.be().m_58904_();
            BlockPos pos = projector.be().m_58899_();
            for (Direction side : Direction.values()) {
                IItemHandler handler = Optional.ofNullable(level.m_7702_(pos.m_121945_(side))).flatMap(neighbor -> neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, side).resolve()).orElse(null);
                if (handler == null) continue;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    BlockItem blockItem;
                    Block block;
                    BlockState state;
                    ItemStack stack = handler.extractItem(i, 1, true);
                    Item item = stack.m_41720_();
                    if (!(item instanceof BlockItem) || (state = (block = (blockItem = (BlockItem)item).m_40614_()).m_49966_()).m_204336_(ModTags.STABILIZATION_BLACKLIST) || ModUtil.isLiquidBlock(block) || !level.m_46597_(position, state)) continue;
                    handler.extractItem(i, 1, false);
                    Vec3 start = Vec3.m_82528_((Vec3i)pos);
                    Vec3 target = Vec3.m_82528_((Vec3i)position);
                    Network.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(position)), (Object)new DrawHologramPacket(start, target, DrawHologramPacket.Type.CONSTRUCT));
                    return this.blockCount++ >= projector.getModuleCount(ModModules.SPEED) / 3 ? Module.ProjectAction.INTERRUPT : Module.ProjectAction.SKIP;
                }
            }
        }
        return Module.ProjectAction.SKIP;
    }
}

