/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.su5ed.mffs.render.LazyRenderer;
import dev.su5ed.mffs.render.RenderPostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

@Mod.EventBusSubscriber(modid="mffs", value={Dist.CLIENT})
public final class RenderTickHandler {
    private static final Map<RenderType, List<LazyRenderer>> transparentRenderers = new HashMap<RenderType, List<LazyRenderer>>();

    public static void addTransparentRenderer(RenderType renderType, LazyRenderer render) {
        transparentRenderers.computeIfAbsent(renderType, r -> new ArrayList()).add(render);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            transparentRenderers.clear();
        }
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft minecraft = Minecraft.m_91087_();
            Camera camera = event.getCamera();
            PoseStack poseStack = event.getPoseStack();
            int ticks = event.getRenderTick();
            float partialTicks = event.getPartialTick();
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            RenderPostProcessor.prepareRender();
            poseStack.m_85836_();
            Vec3 camPos = camera.m_90583_();
            poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
            Consumer<TransparentRenderInfo> consumer = info -> info.render(poseStack, bufferSource, ticks, partialTicks);
            if (transparentRenderers.size() == 1) {
                EntryStream.of(transparentRenderers).mapKeyValue(TransparentRenderInfo::new).forEach(consumer);
            } else {
                ((StreamEx)EntryStream.of(transparentRenderers).mapKeyValue((renderType, renderers) -> {
                    double closest = StreamEx.of((Collection)renderers).mapPartial(renderer -> Optional.ofNullable(renderer.centerPos())).mapToDouble(arg_0 -> ((Vec3)camPos).m_82557_(arg_0)).min().orElse(Double.MAX_VALUE);
                    return new TransparentRenderInfo((RenderType)renderType, (List<LazyRenderer>)renderers, closest);
                }).reverseSorted(Comparator.comparingDouble(TransparentRenderInfo::closest))).forEachOrdered(consumer);
            }
            transparentRenderers.clear();
            poseStack.m_85849_();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            RenderPostProcessor.process(event.getRenderTick());
        }
    }

    private RenderTickHandler() {
    }

    public record TransparentRenderInfo(RenderType renderType, List<LazyRenderer> renders, double closest) {
        public TransparentRenderInfo(RenderType renderType, List<LazyRenderer> renders) {
            this(renderType, renders, 0.0);
        }

        private void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int ticks, float partialTicks) {
            VertexConsumer buffer = bufferSource.m_6299_(this.renderType);
            for (LazyRenderer renderer : this.renders) {
                renderer.render(poseStack, buffer, ticks, partialTicks);
            }
            bufferSource.m_109912_(this.renderType);
        }
    }
}

