/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.api.ForceFieldBlock;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.network.InitialDataRequestPacket;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.render.BlockEntityRenderDelegate;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class ForceFieldBlockEntity
extends BlockEntity {
    private BlockPos projector;
    private BlockState camouflage;
    private int clientBlockLight;

    public ForceFieldBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get(), pos, state);
    }

    public int getClientBlockLight() {
        return this.clientBlockLight;
    }

    public void setProjector(BlockPos position) {
        this.projector = position;
        this.m_6596_();
    }

    public BlockState getCamouflage() {
        return this.camouflage;
    }

    public void setCamouflage(BlockState camouflage) {
        this.camouflage = camouflage;
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.f_46443_) {
            InitialDataRequestPacket packet = new InitialDataRequestPacket(this.f_58858_);
            Network.INSTANCE.sendToServer((Object)packet);
            if (this.camouflage != null) {
                BlockEntityRenderDelegate.INSTANCE.putDelegateFor(this, this.camouflage);
            }
        }
    }

    public void m_7651_() {
        if (this.f_58857_.f_46443_) {
            BlockEntityRenderDelegate.INSTANCE.removeDelegateOf(this);
        }
        super.m_7651_();
    }

    public ModelData getModelData() {
        if (this.camouflage != null) {
            return ModelData.builder().with(ForceFieldBlock.CAMOUFLAGE_BLOCK, (Object)this.camouflage).build();
        }
        return super.getModelData();
    }

    public Optional<Projector> getProjector() {
        return this.projector != null ? Optional.ofNullable(this.f_58857_.m_7702_(this.projector)).flatMap(be -> be.getCapability(ModCapabilities.PROJECTOR).resolve()) : Optional.empty();
    }

    public CompoundTag getCustomUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        if (this.projector != null) {
            tag.m_128365_("projector", (Tag)NbtUtils.m_129224_((BlockPos)this.projector));
        }
        int clientBlockLight = this.getProjector().map(projector -> Math.round((float)Math.min(projector.getModuleCount(ModModules.GLOW), 64) / 64.0f * 15.0f)).orElse(0);
        tag.m_128405_("clientBlockLight", clientBlockLight);
        return tag;
    }

    public void handleCustomUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
        this.projector = tag.m_128441_("projector") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("projector")) : null;
        this.clientBlockLight = tag.m_128451_("clientBlockLight");
        this.updateRenderClient();
        this.f_58857_.m_5518_().m_7174_(this.f_58858_);
        if (this.camouflage != null) {
            BlockEntityRenderDelegate.INSTANCE.putDelegateFor(this, this.camouflage);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.projector != null) {
            tag.m_128365_("projector", (Tag)NbtUtils.m_129224_((BlockPos)this.projector));
        }
        if (this.camouflage != null) {
            tag.m_128365_("camouflage", (Tag)NbtUtils.m_129202_((BlockState)this.camouflage));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("projector")) {
            this.projector = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("projector"));
        }
        if (tag.m_128441_("camouflage")) {
            this.camouflage = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("camouflage"));
        }
    }

    public void updateRenderClient() {
        this.requestModelDataUpdate();
        BlockState state = this.m_58900_();
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }
}

