/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.card.IdentificationCard;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.menu.BiometricIdentifierMenu;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.CopyingIdentificationCard;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class BiometricIdentifierBlockEntity
extends FortronBlockEntity
implements BiometricIdentifier {
    public final InventorySlot masterSlot;
    public final InventorySlot rightsSlot;
    public final InventorySlot copySlot;
    public final List<InventorySlot> identitySlots;
    private final LazyOptional<BiometricIdentifier> identifierCap = LazyOptional.of(() -> this);

    public BiometricIdentifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseBlockEntity>)((BlockEntityType)ModObjects.BIOMETRIC_IDENTIFIER_BLOCK_ENTITY.get()), pos, state);
        this.masterSlot = this.addSlot("master", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard);
        this.rightsSlot = this.addSlot("rights", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard);
        this.copySlot = this.addSlot("copy", InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard, this::copyCard);
        this.identitySlots = IntStreamEx.range((int)9).mapToObj(i -> this.addSlot("identity_" + i, InventorySlot.Mode.BOTH, ModUtil::isIdentificationCard)).toList();
    }

    @Override
    public LazyOptional<IdentificationCard> getManipulatingCard() {
        return this.rightsSlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD).lazyMap(card -> this.copySlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD).map(copy -> new CopyingIdentificationCard((IdentificationCard)card, (IdentificationCard)copy)).orElse(card));
    }

    private void copyCard(ItemStack stack) {
        this.rightsSlot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD).ifPresent(card -> stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).ifPresent(card::copyTo));
    }

    @Override
    public void setActive(boolean active) {
        if (!this.masterSlot.isEmpty() || !active) {
            super.setActive(active);
        }
    }

    @Override
    public boolean isActive() {
        return !this.masterSlot.isEmpty() && super.isActive();
    }

    @Override
    protected void animate() {
        super.animate();
        if (!this.isActive()) {
            this.animation = 0;
        }
    }

    @Override
    public boolean isAccessGranted(Player player, FieldPermission permission) {
        return !this.isActive() || BiometricIdentifierBlockEntity.canOpBypass(player) || StreamEx.of((Object)this.masterSlot).append(this.identitySlots).anyMatch(slot -> slot.getItem().getCapability(ModCapabilities.IDENTIFICATION_CARD).map(card -> card.checkIdentity(player)).orElse(false));
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.BIOMETRIC_IDENTIFIER) {
            return this.identifierCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new BiometricIdentifierMenu(containerId, this.f_58858_, player, playerInventory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canOpBypass(Player player) {
        if (!(player instanceof ServerPlayer)) return false;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if ((Boolean)MFFSConfig.COMMON.allowOpBiometryOverride.get() == false) return false;
        if (!serverPlayer.f_8924_.m_6846_().m_11303_(player.m_36316_())) return false;
        return true;
    }
}

