/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network.packets;

import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.network.ServerToClientPacket;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientSyncPacket
extends ServerToClientPacket<ClientSyncPacket> {
    private BlockPos pos;
    private int flags;
    private CompoundTag sideConfig;
    private double transferRate;
    private TypeEnums.NUMBER_MODE numberMode;
    private TypeEnums.STATUS status;
    private TypeEnums.MODE mode;
    private TypeEnums.ACCURACY accuracy;
    private int interval;
    private int threshold;

    public ClientSyncPacket(BlockPos pos, int flags, SideConfiguration sideConfig, double transferRate, TypeEnums.NUMBER_MODE numberMode, TypeEnums.STATUS status, TypeEnums.MODE mode, TypeEnums.ACCURACY accuracy, int interval, int threshold) {
        this.pos = pos;
        this.flags = flags;
        this.sideConfig = sideConfig.serializeNBT();
        this.transferRate = transferRate;
        this.numberMode = numberMode;
        this.status = status;
        this.mode = mode;
        this.accuracy = accuracy;
        this.interval = interval;
        this.threshold = threshold;
    }

    public ClientSyncPacket() {
    }

    @Override
    public void encode(ClientSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.flags);
        if ((packet.flags & 1) != 0) {
            buffer.m_130079_(packet.sideConfig);
        }
        if ((packet.flags & 2) != 0) {
            buffer.writeDouble(packet.transferRate);
        }
        if ((packet.flags & 4) != 0) {
            buffer.writeInt(packet.numberMode.ordinal());
        }
        if ((packet.flags & 8) != 0) {
            buffer.writeInt(packet.status.ordinal());
        }
        if ((packet.flags & 0x10) != 0) {
            buffer.writeInt(packet.mode.ordinal());
        }
        if ((packet.flags & 0x20) != 0) {
            buffer.writeInt(packet.accuracy.ordinal());
        }
        if ((packet.flags & 0x40) != 0) {
            buffer.writeInt(packet.interval);
        }
        if ((packet.flags & 0x80) != 0) {
            buffer.writeInt(packet.threshold);
        }
    }

    @Override
    public ClientSyncPacket decode(FriendlyByteBuf buffer) {
        ClientSyncPacket packet = new ClientSyncPacket();
        packet.pos = buffer.m_130135_();
        packet.flags = buffer.readInt();
        if ((packet.flags & 1) != 0) {
            packet.sideConfig = Objects.requireNonNull(buffer.m_130260_());
        }
        if ((packet.flags & 2) != 0) {
            packet.transferRate = buffer.readDouble();
        }
        if ((packet.flags & 4) != 0) {
            packet.numberMode = TypeEnums.NUMBER_MODE.values()[buffer.readInt()];
        }
        if ((packet.flags & 8) != 0) {
            packet.status = TypeEnums.STATUS.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x10) != 0) {
            packet.mode = TypeEnums.MODE.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x20) != 0) {
            packet.accuracy = TypeEnums.ACCURACY.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x40) != 0) {
            packet.interval = buffer.readInt();
        }
        if ((packet.flags & 0x80) != 0) {
            packet.threshold = buffer.readInt();
        }
        return packet;
    }

    @Override
    protected void handlePacket(ClientSyncPacket packet, ClientLevel level) {
        BlockEntity entity = level.m_7702_(packet.pos);
        if (entity instanceof MeterEntity) {
            MeterEntity tile = (MeterEntity)entity;
            if ((packet.flags & 1) != 0) {
                tile.getSideConfig().deserializeNBT(packet.sideConfig);
            }
            if ((packet.flags & 2) != 0) {
                tile.setTransferRate(packet.transferRate);
            }
            if ((packet.flags & 4) != 0) {
                tile.setNumberMode(packet.numberMode);
            }
            if ((packet.flags & 8) != 0) {
                tile.setStatus(packet.status);
            }
            if ((packet.flags & 0x10) != 0) {
                tile.setMode(packet.mode);
            }
            if ((packet.flags & 0x20) != 0) {
                tile.setAccuracy(packet.accuracy);
            }
            if ((packet.flags & 0x40) != 0) {
                tile.setInterval(packet.interval);
            }
            if ((packet.flags & 0x80) != 0) {
                tile.setThreshold(packet.threshold);
            }
        }
    }
}

