/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.refinedpolymorph;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.client.base.IPolymorphClient;
import com.illusivesoulworks.polymorph.api.client.base.IRecipesWidget;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphCommon;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import gripe._90.refinedpolymorph.CraftingGrid;
import gripe._90.refinedpolymorph.GridBlockEntityRecipeData;
import gripe._90.refinedpolymorph.GridRecipeWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="refinedpolymorph")
public class RefinedPolymorphism {
    public RefinedPolymorphism() {
        IPolymorphCommon common = PolymorphApi.common();
        common.registerContainer2BlockEntity(menu -> {
            BaseBlockEntity baseBlockEntity;
            if (menu instanceof GridContainerMenu) {
                GridContainerMenu grid = (GridContainerMenu)menu;
                baseBlockEntity = grid.getBlockEntity();
            } else {
                baseBlockEntity = null;
            }
            return baseBlockEntity;
        });
        common.registerBlockEntity2RecipeData(be -> {
            GridBlockEntityRecipeData gridBlockEntityRecipeData;
            if (be instanceof GridBlockEntity) {
                GridBlockEntity grid = (GridBlockEntity)be;
                gridBlockEntityRecipeData = new GridBlockEntityRecipeData(grid);
            } else {
                gridBlockEntityRecipeData = null;
            }
            return gridBlockEntityRecipeData;
        });
        if (FMLEnvironment.dist.isClient()) {
            Client.registerWidget();
        }
    }

    public static void onSelect(Recipe<?> recipe, IGrid grid) {
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            if (grid instanceof CraftingGrid) {
                CraftingGrid craftingGrid = (CraftingGrid)grid;
                craftingGrid.refinedpolymorph$setCurrentRecipe(craftingRecipe);
                grid.onCraftingMatrixChanged();
            }
        }
    }

    private static class Client {
        private Client() {
        }

        private static void registerWidget() {
            IPolymorphClient client = PolymorphApi.client();
            client.registerWidget(screen -> {
                IRecipesWidget iRecipesWidget;
                if (screen instanceof GridScreen) {
                    GridScreen grid = (GridScreen)screen;
                    iRecipesWidget = client.findCraftingResultSlot((AbstractContainerScreen)grid).map(slot -> new GridRecipeWidget(grid, (Slot)slot)).orElse(null);
                } else {
                    iRecipesWidget = null;
                }
                return iRecipesWidget;
            });
        }
    }
}

