/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.platform;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.network.handler.ForgeFirePacketHandler;
import it.crystalnest.soul_fire_d.network.packet.RegisterFirePacket;
import it.crystalnest.soul_fire_d.network.packet.UnregisterFirePacket;
import it.crystalnest.soul_fire_d.platform.services.NetworkHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgeNetworkHelper
implements NetworkHelper {
    private static final String CHANNEL_VERSION = "1.20.1-4";
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("soul_fire_d", "ddfires")).networkProtocolVersion(() -> "1.20.1-4").clientAcceptedVersions("1.20.1-4"::equals).serverAcceptedVersions("1.20.1-4"::equals).simpleChannel();
    private static int id = 0;

    private static int id() {
        return id++;
    }

    @Override
    public void register() {
        INSTANCE.messageBuilder(RegisterFirePacket.class, ForgeNetworkHelper.id()).encoder(RegisterFirePacket::write).decoder(RegisterFirePacket::new).consumerNetworkThread(ForgeFirePacketHandler::handleRegister).add();
        INSTANCE.messageBuilder(UnregisterFirePacket.class, ForgeNetworkHelper.id()).encoder(UnregisterFirePacket::write).decoder(UnregisterFirePacket::new).consumerNetworkThread(ForgeFirePacketHandler::handleUnregister).add();
    }

    @Override
    public void sendToClient(@Nullable ServerPlayer player, Fire fire) {
        if (player == null) {
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new RegisterFirePacket(fire));
        } else {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RegisterFirePacket(fire));
        }
    }

    @Override
    public void sendToClient(@Nullable ServerPlayer player, ResourceLocation fireType) {
        if (player == null) {
            INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnregisterFirePacket(fireType));
        } else {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UnregisterFirePacket(fireType));
        }
    }
}

