/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.mixin.cokeoven;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.crafting.serializers.CokeOvenRecipeSerializer;
import blusunrize.immersiveengineering.common.register.IEFluids;
import com.google.gson.JsonObject;
import com.pression.compressedengineering.interfaces.CokeOvenFluidOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CokeOvenRecipeSerializer.class})
public abstract class CokeOvenSerializerMixin
extends IERecipeSerializer<CokeOvenRecipe> {
    @Inject(method={"readFromJson(Lnet/minecraft/resources/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraftforge/common/crafting/conditions/ICondition$IContext;)Lblusunrize/immersiveengineering/api/crafting/CokeOvenRecipe;"}, remap=false, cancellable=true, at={@At(value="RETURN")})
    public void addFluidToRecipe(ResourceLocation recipeId, JsonObject json, ICondition.IContext context, CallbackInfoReturnable<CokeOvenRecipe> cir) {
        CokeOvenRecipe recipe = (CokeOvenRecipe)cir.getReturnValue();
        int oil = recipe.creosoteOutput;
        FluidStack fluid = FluidStack.EMPTY;
        if (oil > 0) {
            fluid = new FluidStack((Fluid)IEFluids.CREOSOTE.getStill(), oil);
        }
        if (json.has("fluid")) {
            oil = 1;
            fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        }
        CokeOvenRecipe newRecipe = new CokeOvenRecipe(recipeId, recipe.output, recipe.input, recipe.time, oil);
        CokeOvenFluidOutput recipeFluid = (CokeOvenFluidOutput)newRecipe;
        recipeFluid.setFluidOutput(fluid);
        cir.setReturnValue((Object)newRecipe);
    }

    @Inject(method={"readFromJson(Lnet/minecraft/resources/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraftforge/common/crafting/conditions/ICondition$IContext;)Lblusunrize/immersiveengineering/api/crafting/CokeOvenRecipe;"}, remap=false, at={@At(value="HEAD")})
    private void recipeSafeguard(ResourceLocation recipeId, JsonObject json, ICondition.IContext context, CallbackInfoReturnable<CokeOvenRecipe> cir) {
        if (!json.has("creosote")) {
            json.addProperty("creosote", (Number)0);
        }
    }

    @Inject(method={"fromNetwork(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/FriendlyByteBuf;)Lblusunrize/immersiveengineering/api/crafting/CokeOvenRecipe;"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private void onFromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, CallbackInfoReturnable<CokeOvenRecipe> cir) {
        CokeOvenRecipe recipe = (CokeOvenRecipe)cir.getReturnValue();
        FluidStack fluid = buffer.readFluidStack();
        CokeOvenFluidOutput recipeFluid = (CokeOvenFluidOutput)recipe;
        recipeFluid.setFluidOutput(fluid);
        cir.setReturnValue((Object)recipe);
    }

    @Inject(method={"toNetwork(Lnet/minecraft/network/FriendlyByteBuf;Lblusunrize/immersiveengineering/api/crafting/CokeOvenRecipe;)V"}, at={@At(value="TAIL")}, remap=false)
    private void onToNetwork(FriendlyByteBuf buffer, CokeOvenRecipe recipe, CallbackInfo ci) {
        CokeOvenFluidOutput recipeFluid = (CokeOvenFluidOutput)recipe;
        buffer.writeFluidStack(recipeFluid.getFluidOutput());
    }
}

