/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.mixin.blastfurnace;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AdvBlastFurnaceLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.pression.compressedengineering.CommonConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FurnaceHandler.class})
public abstract class BlastFurnaceBurnTimeMixin {
    @Unique
    private static final BlockPos[] PREHEATERS = new BlockPos[]{new BlockPos(-1, 0, 1), new BlockPos(3, 0, 1)};
    @Unique
    private int lastPreheaters = -1;
    @Unique
    private IMultiblockContext<? extends FurnaceHandler.IFurnaceEnvironment<?>> capturedContext;
    @Shadow(remap=false)
    private int burnTime;
    @Shadow(remap=false)
    private int lastBurnTime;
    @Shadow(remap=false)
    private int process;

    @Inject(method={"tickServer"}, at={@At(value="HEAD")}, remap=false)
    private void captureCtx(IMultiblockContext<? extends FurnaceHandler.IFurnaceEnvironment<?>> ctx, CallbackInfoReturnable<Boolean> cir) {
        this.capturedContext = ctx;
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")}, remap=false)
    private void onTick(IMultiblockContext<? extends FurnaceHandler.IFurnaceEnvironment<?>> ctx, CallbackInfoReturnable<Boolean> cir) {
        Object object = ctx.getState();
        if (object instanceof AdvBlastFurnaceLogic.State) {
            AdvBlastFurnaceLogic.State state = (AdvBlastFurnaceLogic.State)object;
            BlastFurnacePreheaterBlockEntity preheaterA = state.getPreheater(ctx.getLevel(), PREHEATERS[0]);
            BlastFurnacePreheaterBlockEntity preheaterB = state.getPreheater(ctx.getLevel(), PREHEATERS[1]);
            int curPreheaters = this.fakePreheaterSpeedup(preheaterA) + this.fakePreheaterSpeedup(preheaterB);
            if (this.lastPreheaters == -1) {
                this.lastPreheaters = curPreheaters;
            }
            if (this.lastPreheaters != curPreheaters) {
                double oldMult = (Double)((List)CommonConfig.IMPROVED_FUEL_MULT.get()).get(this.lastPreheaters);
                double newMult = (Double)((List)CommonConfig.IMPROVED_FUEL_MULT.get()).get(curPreheaters);
                this.burnTime = (int)((double)this.burnTime / oldMult * newMult);
                this.lastBurnTime = (int)((double)this.lastBurnTime / oldMult * newMult);
                this.lastPreheaters = curPreheaters;
            }
        }
    }

    @Redirect(method={"tickServer"}, remap=false, at=@At(value="INVOKE", target="Lblusunrize/immersiveengineering/common/blocks/multiblocks/logic/FurnaceHandler$IFurnaceEnvironment;getBurnTimeOf(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)I"))
    private int modifyBurnTime(FurnaceHandler.IFurnaceEnvironment<?> instance, Level level, ItemStack itemStack) {
        int time = instance.getBurnTimeOf(level, itemStack);
        Object object = this.capturedContext.getState();
        if (object instanceof AdvBlastFurnaceLogic.State) {
            AdvBlastFurnaceLogic.State state = (AdvBlastFurnaceLogic.State)object;
            if (time > 0) {
                BlastFurnacePreheaterBlockEntity preheaterA = state.getPreheater(this.capturedContext.getLevel(), PREHEATERS[0]);
                BlastFurnacePreheaterBlockEntity preheaterB = state.getPreheater(this.capturedContext.getLevel(), PREHEATERS[1]);
                int index = 0;
                if (preheaterA != null) {
                    index += preheaterA.doSpeedup();
                }
                if (preheaterB != null) {
                    index += preheaterB.doSpeedup();
                }
                time = (int)((double)time * (Double)((List)CommonConfig.IMPROVED_FUEL_MULT.get()).get(index));
                this.lastPreheaters = index;
            }
        }
        return time;
    }

    @Unique
    private int fakePreheaterSpeedup(BlastFurnacePreheaterBlockEntity preheater) {
        if (preheater == null) {
            return 0;
        }
        int consumed = (Integer)IEServerConfig.MACHINES.preheater_consumption.get();
        if (preheater.energyStorage.extractEnergy(consumed, true) == consumed) {
            return 1;
        }
        return 0;
    }
}

