/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.mixin;

import blusunrize.immersiveengineering.common.fluids.ConcreteFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEPotions;
import com.pression.compressedengineering.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ConcreteFluid.class})
public class ConcreteFluidMixin {
    @Unique
    private static final boolean ENABLE_ALT_IMPL = (Boolean)CommonConfig.ALT_CONCRETE.get();

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lblusunrize/immersiveengineering/common/fluids/ConcreteFluid;isSource(Lnet/minecraft/world/level/material/FluidState;)Z")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onTick(Level world, BlockPos pos, FluidState state, CallbackInfo ci, int timer, int level, int quantaRemaining, boolean mayDry) {
        if (!ENABLE_ALT_IMPL) {
            return;
        }
        mayDry = false;
        if (!state.m_76170_()) {
            ci.cancel();
        } else if (timer >= 31) {
            this.hardenRecursive(world, pos, state);
        }
    }

    private void hardenRecursive(Level world, BlockPos pos, FluidState state) {
        this.hardenBlock(world, pos, state);
        Direction.m_235666_().forEach(direction -> {
            FluidState newState = world.m_8055_(pos.m_121945_(direction)).m_60819_();
            if (newState.m_76152_().m_6212_(state.m_76152_())) {
                this.hardenRecursive(world, pos.m_121945_(direction), newState);
            }
        });
    }

    private void hardenBlock(Level world, BlockPos pos, FluidState state) {
        int fluidLevel = this.getFluidLevel(state);
        IEBlocks.BlockEntry concreteBlock = fluidLevel >= 5 && fluidLevel < 8 ? (IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE.getId()) : IEBlocks.StoneDecoration.CONCRETE;
        world.m_46597_(pos, concreteBlock.get().m_49966_());
        for (LivingEntity living : world.m_45976_(LivingEntity.class, new AABB(pos, pos.m_7918_(1, 1, 1)))) {
            living.m_7292_(new MobEffectInstance((MobEffect)IEPotions.CONCRETE_FEET.get(), Integer.MAX_VALUE));
        }
    }

    private int getFluidLevel(FluidState state) {
        return state.m_76170_() ? 0 : 8 - Math.min(state.m_76186_(), 8) + ((Boolean)state.m_61143_((Property)FlowingFluid.f_75947_) != false ? 8 : 0);
    }
}

