/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.jei;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MineralMixRecipeCategory
implements IRecipeCategory<MineralMix> {
    public static final RecipeType<MineralMix> TYPE = RecipeType.create((String)"compressedengineering", (String)"excavator_veins", MineralMix.class);
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable overlay;
    private final ResourceLocation texPath = new ResourceLocation("compressedengineering", "textures/gui/jei_excavator.png");
    private final List<Integer> colours = List.of(Integer.valueOf(-2002124800), Integer.valueOf(-1996510720), Integer.valueOf(-2013222400), Integer.valueOf(-2013265750), Integer.valueOf(-2002124630), Integer.valueOf(-2013222230));

    public MineralMixRecipeCategory(IGuiHelper guiHelper) {
        this.title = Component.m_237115_((String)"compressedengineering.jei.excavator_title");
        this.background = guiHelper.createBlankDrawable(180, 105);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)IEMultiblockLogic.EXCAVATOR.iconStack());
        this.overlay = guiHelper.createDrawable(this.texPath, 0, 0, 180, 105);
    }

    public RecipeType<MineralMix> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(MineralMix recipe, IRecipeSlotsView slotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int x2;
        StackWithChance output;
        int i;
        RenderSystem.enableBlend();
        this.overlay.draw(graphics, 0, 0);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent veinNameText = Component.m_237115_((String)recipe.getTranslationKey());
        MutableComponent failChanceText = recipe.spoils.length > 0 ? Component.m_237110_((String)"compressedengineering.jei.basefailchance", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(recipe.failChance * 100.0f))}) : Component.m_237110_((String)"compressedengineering.jei.basefailchance_nospoils", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(recipe.failChance * 100.0f))});
        graphics.drawString(font, veinNameText.m_7532_(), (float)this.background.getWidth() / 2.0f - (float)font.m_92895_(veinNameText.getString()) / 2.0f, 0.0f, 0x888888, false);
        graphics.drawString(font, failChanceText.m_7532_(), (float)this.background.getWidth() / 2.0f - (float)font.m_92895_(failChanceText.getString()) / 2.0f, 52.0f, 0x888888, false);
        float barFilled = (float)this.background.getWidth() / 2.0f - 75.0f;
        int area = (this.background.getWidth() - 16 - 16 * recipe.outputs.length) / 2;
        int xOffset = 16;
        int col = 0;
        for (i = 0; i < recipe.outputs.length; ++i) {
            output = recipe.outputs[i];
            x2 = Math.round(barFilled + output.chance() * 75.0f);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), xOffset += (int)((float)area * output.chance() + 8.0f), 28.0f, xOffset, 32.0f, -10066330);
            graphics.m_280509_(xOffset - 1, 31, xOffset + 1, 33, -10066330);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), xOffset, 32.0f, x2, 36.0f, -10066330);
            graphics.m_280509_(x2 - 1, 35, x2 + 1, 37, -10066330);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), x2, 36.0f, x2, 40.0f, -10066330);
            graphics.m_280509_((int)barFilled, 40, (int)(barFilled + output.chance() * 150.0f), 47, this.colours.get(col).intValue());
            if (++col >= this.colours.size()) {
                col = 0;
            }
            barFilled += output.chance() * 150.0f;
            xOffset += (int)((float)area * output.chance() + 8.0f);
        }
        barFilled = (float)this.background.getWidth() / 2.0f - 75.0f;
        area = (this.background.getWidth() - 16 - 16 * recipe.spoils.length) / 2;
        xOffset = 16;
        col = 0;
        for (i = 0; i < recipe.spoils.length; ++i) {
            output = recipe.spoils[i];
            x2 = Math.round(barFilled + output.chance() * 75.0f);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), xOffset += (int)((float)area * output.chance() + 8.0f), 80.0f, xOffset, 84.0f, -10066330);
            graphics.m_280509_(xOffset - 1, 83, xOffset + 1, 85, -10066330);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), xOffset, 84.0f, x2, 88.0f, -10066330);
            graphics.m_280509_(x2 - 1, 87, x2 + 1, 89, -10066330);
            MineralMixRecipeCategory.drawLine(graphics.m_280168_(), x2, 88.0f, x2, 92.0f, -10066330);
            graphics.m_280509_((int)barFilled, 92, (int)(barFilled + output.chance() * 150.0f), 99, this.colours.get(col).intValue());
            if (++col >= this.colours.size()) {
                col = 0;
            }
            barFilled += output.chance() * 150.0f;
            xOffset += (int)((float)area * output.chance() + 8.0f);
        }
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MineralMix recipe, IFocusGroup focuses) {
        StackWithChance output;
        int i;
        int area = (this.background.getWidth() - 16 - 16 * recipe.outputs.length) / 2;
        int xOffset = 16;
        for (i = 0; i < recipe.outputs.length; ++i) {
            output = recipe.outputs[i];
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (xOffset += (int)((float)area * output.chance() + 8.0f)) - 8, 12).addItemStack((ItemStack)output.stack().get())).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(1, Component.m_237110_((String)"compressedengineering.jei.outputchance", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(output.chance() * 100.0f))})));
            xOffset += (int)((float)area * output.chance() + 8.0f);
        }
        area = (this.background.getWidth() - 16 - 16 * recipe.spoils.length) / 2;
        xOffset = 16;
        for (i = 0; i < recipe.spoils.length; ++i) {
            output = recipe.spoils[i];
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (xOffset += (int)((float)area * output.chance() + 8.0f)) - 8, 64).addItemStack((ItemStack)output.stack().get())).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(1, Component.m_237110_((String)"compressedengineering.jei.outputchance", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(output.chance() * 100.0f))})));
            xOffset += (int)((float)area * output.chance() + 8.0f);
        }
        ItemStack coreSample = new ItemStack((ItemLike)IEItems.Misc.CORESAMPLE);
        try {
            coreSample.m_41751_(TagParser.m_129359_((String)("{dimension:\"minecraft:overworld\",mineralInfo:[{depletion:0,mineral:\"immersiveengineering:mineral/" + recipe.getPlainName() + "\",percentage:1.0d,saturation:1.0d}],timestamp:0L,x:0,z:0}")));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(coreSample)).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.m_237115_((String)"compressedengineering.jei.core_sample_disclaimer")));
    }

    @NotNull
    public List<Component> getTooltipStrings(MineralMix recipe, IRecipeSlotsView slotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        MutableComponent veinName = Component.m_237115_((String)recipe.getTranslationKey());
        MutableComponent failChance = recipe.spoils.length > 0 ? Component.m_237110_((String)"compressedengineering.jei.basefailchance", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(recipe.failChance * 100.0f))}) : Component.m_237110_((String)"compressedengineering.jei.basefailchance_nospoils", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(recipe.failChance * 100.0f))});
        Font font = Minecraft.m_91087_().f_91062_;
        if (mouseY < 12.0 && mouseX > (double)this.background.getWidth() / 2.0 - (double)font.m_92895_(veinName.getString()) / 2.0 && mouseX < (double)this.background.getWidth() / 2.0 + (double)font.m_92895_(veinName.getString()) / 2.0) {
            tooltips.add((Component)Component.m_237110_((String)"compressedengineering.jei.vein_weight_1", (Object[])new Object[]{recipe.weight}));
            tooltips.add((Component)Component.m_237115_((String)"compressedengineering.jei.vein_weight_2"));
            tooltips.add((Component)Component.m_237115_((String)"compressedengineering.jei.dimensions_list"));
            recipe.dimensions.forEach(dim -> tooltips.add((Component)Component.m_237113_((String)(dim.m_135782_().m_135827_() + ":" + dim.m_135782_().m_135815_()))));
        }
        if (mouseY > 52.0 && mouseY < 64.0 && mouseX > (double)this.background.getWidth() / 2.0 - (double)font.m_92895_(failChance.getString()) / 2.0 && mouseX < (double)this.background.getWidth() / 2.0 + (double)font.m_92895_(failChance.getString()) / 2.0) {
            tooltips.add((Component)Component.m_237115_((String)"compressedengineering.jei.spoils_guide"));
        }
        return tooltips;
    }

    private static void drawLine(PoseStack ms, float x1, float y1, float x2, float y2, int col) {
        float deltaX = x1 - x2;
        float deltaY = y1 - y2;
        float magnitude = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        if (magnitude == 0.0f) {
            return;
        }
        deltaX /= magnitude;
        deltaY /= magnitude;
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = ms.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, x2 + deltaY, y2 - deltaX, 0.0f).m_193479_(col).m_5752_();
        buffer.m_252986_(matrix, x2 - deltaY, y2 + deltaX, 0.0f).m_193479_(col).m_5752_();
        buffer.m_252986_(matrix, x1 - deltaY, y1 + deltaX, 0.0f).m_193479_(col).m_5752_();
        buffer.m_252986_(matrix, x1 + deltaY, y1 - deltaX, 0.0f).m_193479_(col).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }
}

