/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.jei;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.pression.compressedengineering.jei.AssemblerOnlyRecipeTransferHandler;
import com.pression.compressedengineering.jei.AssemblerRecipeCategory;
import com.pression.compressedengineering.jei.MineralMixRecipeCategory;
import com.pression.compressedengineering.recipe.CERecipeTypes;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("compressedengineering", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AssemblerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MineralMixRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel mcLevel = Minecraft.m_91087_().f_91073_;
        if (mcLevel == null) {
            return;
        }
        List shapedRecipes = mcLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)CERecipeTypes.SHAPED_ASSEMBLY_RECIPE_TYPE.get());
        List shapelessRecipes = mcLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)CERecipeTypes.SHAPELESS_ASSEMBLY_RECIPE_TYPE.get());
        ArrayList recipes = new ArrayList();
        recipes.addAll(shapedRecipes);
        recipes.addAll(shapelessRecipes);
        registration.addRecipes(AssemblerRecipeCategory.TYPE, recipes);
        List mineralMixRecipes = mcLevel.m_7465_().m_44013_(IERecipeTypes.MINERAL_MIX.get());
        ArrayList<MineralMix> enabledVeins = new ArrayList<MineralMix>();
        for (MineralMix vein : mineralMixRecipes) {
            if (vein.weight <= 0) continue;
            enabledVeins.add(vein);
        }
        registration.addRecipes(MineralMixRecipeCategory.TYPE, enabledVeins);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(IEMultiblockLogic.ASSEMBLER.iconStack(), new RecipeType[]{AssemblerRecipeCategory.TYPE});
        registration.addRecipeCatalyst(IEMultiblockLogic.EXCAVATOR.iconStack(), new RecipeType[]{MineralMixRecipeCategory.TYPE});
        registration.addRecipeCatalyst(IEMultiblockLogic.BUCKET_WHEEL.iconStack(), new RecipeType[]{MineralMixRecipeCategory.TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new AssemblerOnlyRecipeTransferHandler(registration.getTransferHelper()), AssemblerRecipeCategory.TYPE);
    }
}

