/*
 * Decompiled with CFR 0.152.
 */
package com.pression.compressedengineering.jei;

import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pression.compressedengineering.recipe.ShapedAssemblerRecipe;
import com.pression.compressedengineering.recipe.ShapelessAssemblerRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;

public class AssemblerRecipeCategory
implements IRecipeCategory<CraftingRecipe> {
    public static final RecipeType<CraftingRecipe> TYPE = RecipeType.create((String)"compressedengineering", (String)"assembler", CraftingRecipe.class);
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable shapeless;
    private final ResourceLocation texture = new ResourceLocation("compressedengineering", "textures/gui/jei_assembler.png");

    public AssemblerRecipeCategory(IGuiHelper guiHelper) {
        this.title = Component.m_237115_((String)"compressedengineering.jei.assembler_title");
        this.background = guiHelper.createDrawable(this.texture, 0, 0, 125, 68);
        this.icon = guiHelper.createDrawableItemStack(IEMultiblockLogic.ASSEMBLER.iconStack());
        this.shapeless = guiHelper.createDrawable(this.texture, 126, 1, 14, 14);
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 26).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        int xOffset = 9;
        int yOffset = 8;
        ArrayList<Object> ingredientList = new ArrayList<Object>();
        if (recipe instanceof ShapedAssemblerRecipe) {
            ShapedAssemblerRecipe r = (ShapedAssemblerRecipe)recipe;
            Object[] objectArray = new Ingredient[9];
            Arrays.fill(objectArray, Ingredient.f_43901_);
            for (int y = 0; y < r.m_44221_(); ++y) {
                for (int x = 0; x < r.m_44220_(); ++x) {
                    objectArray[y * 3 + x] = (Ingredient)r.m_7527_().get(y * r.m_44220_() + x);
                }
            }
            ingredientList.addAll(List.of(objectArray));
        } else {
            ingredientList.addAll((Collection<Object>)recipe.m_7527_());
        }
        for (Ingredient ingredient : ingredientList) {
            if (ingredient.m_43947_()) {
                builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset);
            } else {
                builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addItemStacks(List.of(ingredient.m_43908_()));
            }
            if ((xOffset += 18) < 50) continue;
            xOffset = 9;
            yOffset += 18;
        }
    }

    public void draw(CraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        if (recipe instanceof ShapelessAssemblerRecipe) {
            ShapelessAssemblerRecipe r = (ShapelessAssemblerRecipe)recipe;
            this.shapeless.draw(graphics, 69, 12);
        }
        RenderSystem.disableBlend();
    }
}

