/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncThermostatModuleToServer
extends LocationIntPacket {
    private final Direction side;
    private final byte channel;
    private final int threshold;

    public PacketSyncThermostatModuleToServer(ThermostatModule module) {
        super(module.getTube().m_58899_());
        this.side = module.getDirection();
        this.channel = (byte)module.getColorChannel();
        this.threshold = module.getThreshold();
    }

    PacketSyncThermostatModuleToServer(FriendlyByteBuf buffer) {
        super(buffer);
        this.side = (Direction)buffer.m_130066_(Direction.class);
        this.channel = buffer.readByte();
        this.threshold = buffer.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.m_130068_((Enum)this.side);
        buf.writeByte((int)this.channel);
        buf.writeInt(this.threshold);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PneumaticCraftUtils.canPlayerReach((Player)player, this.pos)) {
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.m_9236_(), this.pos, PressureTubeBlockEntity.class).ifPresent(tube -> {
                    AbstractTubeModule patt2592$temp = tube.getModule(this.side);
                    if (patt2592$temp instanceof ThermostatModule) {
                        ThermostatModule mr = (ThermostatModule)patt2592$temp;
                        mr.setColorChannel(this.channel);
                        mr.setThreshold(this.threshold);
                        mr.updateNeighbors();
                        mr.setUpdate(true);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

