/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.WidgetSerializer;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketProgrammerUpdate
extends LocationIntPacket
implements ILargePayload {
    private final List<IProgWidget> widgets;

    public PacketProgrammerUpdate(ProgrammerBlockEntity te) {
        super(te.m_58899_());
        this.widgets = te.progWidgets;
    }

    public PacketProgrammerUpdate(FriendlyByteBuf buffer) {
        super(buffer);
        this.widgets = WidgetSerializer.readWidgetsFromPacket(buffer);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        WidgetSerializer.writeProgWidgetsToPacket(this.widgets, buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.updateTE((Player)((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    private void updateTE(Player player) {
        PacketUtil.getBlockEntity(player, this.pos, ProgrammerBlockEntity.class).ifPresent(te -> te.setProgWidgets(this.widgets, player));
    }

    @Override
    public FriendlyByteBuf dumpToBuffer() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.toBytes(buf);
        return buf;
    }

    @Override
    public void handleLargePayload(Player player) {
        this.updateTE(player);
    }
}

