/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlayMovingSound {
    private final MovingSounds.Sound sound;
    private final MovingSoundFocus source;

    public PacketPlayMovingSound(MovingSounds.Sound sound, MovingSoundFocus source) {
        this.sound = sound;
        this.source = source;
    }

    public PacketPlayMovingSound(FriendlyByteBuf buffer) {
        this.sound = (MovingSounds.Sound)buffer.m_130066_(MovingSounds.Sound.class);
        this.source = MovingSoundFocus.fromBytes(buffer);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.sound);
        this.source.toBytes(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.source != null) {
                this.source.handle(this.sound);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class MovingSoundFocus {
        private final Either<Entity, BlockPos> entityOrPos;

        private MovingSoundFocus(Either<Entity, BlockPos> entityOrPos) {
            this.entityOrPos = entityOrPos;
        }

        public static MovingSoundFocus of(Entity e) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.left((Object)e));
        }

        public static MovingSoundFocus of(int id) {
            Entity e = ClientUtils.getClientLevel().m_6815_(id);
            return e == null ? null : MovingSoundFocus.of(e);
        }

        public static MovingSoundFocus of(BlockPos pos) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.right((Object)pos));
        }

        public static MovingSoundFocus of(BlockEntity te) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.right((Object)te.m_58899_()));
        }

        public static MovingSoundFocus fromBytes(FriendlyByteBuf buf) {
            SourceType type = (SourceType)buf.m_130066_(SourceType.class);
            return type.getSource(buf);
        }

        void toBytes(FriendlyByteBuf buf) {
            this.entityOrPos.ifLeft(id -> {
                buf.m_130068_((Enum)SourceType.ENTITY);
                buf.writeInt(id.m_19879_());
            }).ifRight(pos -> {
                buf.m_130068_((Enum)SourceType.STATIC_POS);
                buf.m_130064_(pos);
            });
        }

        public void handle(MovingSounds.Sound sound) {
            this.entityOrPos.ifLeft(e -> MovingSounds.playMovingSound(sound, e, new Object[0])).ifRight(pos -> MovingSounds.playMovingSound(sound, pos, new Object[0]));
        }

        public Either<Entity, BlockPos> asEntityOrPos() {
            return this.entityOrPos;
        }
    }

    private static enum SourceType {
        ENTITY(buf -> MovingSoundFocus.of(buf.readInt())),
        STATIC_POS(buf -> MovingSoundFocus.of(buf.m_130135_()));

        private final Function<FriendlyByteBuf, MovingSoundFocus> creator;

        private SourceType(Function<FriendlyByteBuf, MovingSoundFocus> creator) {
            this.creator = creator;
        }

        public MovingSoundFocus getSource(FriendlyByteBuf buf) {
            return this.creator.apply(buf);
        }
    }
}

