/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.block.AssemblyControllerBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramDrillLaser;
import me.desht.pneumaticcraft.common.recipes.assembly.ProgramLaser;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AssemblyProgramItem
extends Item {
    private static final AssemblyProgram[] PROGRAMS = new AssemblyProgram[AssemblyRecipe.AssemblyProgramType.values().length];
    private final AssemblyRecipe.AssemblyProgramType programType;

    public AssemblyProgramItem(AssemblyRecipe.AssemblyProgramType programType) {
        super(ModItems.defaultProps());
        this.programType = programType;
    }

    public AssemblyRecipe.AssemblyProgramType getProgramType() {
        return this.programType;
    }

    public AssemblyProgram getProgram() {
        return PROGRAMS[this.programType.ordinal()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag par4) {
        infoList.add((Component)Component.m_237113_((String)"Required Machines:"));
        infoList.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate(((AssemblyControllerBlock)ModBlocks.ASSEMBLY_CONTROLLER.get()).m_7705_(), new Object[0])));
        Arrays.stream(this.getProgram().getRequiredMachines()).map(machine -> Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate(machine.getMachineBlock().m_7705_(), new Object[0]))).forEach(infoList::add);
    }

    public static AssemblyProgramItem fromProgramType(AssemblyRecipe.AssemblyProgramType program) {
        return PROGRAMS[program.ordinal()].getItem();
    }

    public static AssemblyProgram getProgram(ItemStack stack) {
        return stack.m_41720_() instanceof AssemblyProgramItem ? ((AssemblyProgramItem)stack.m_41720_()).getProgram() : null;
    }

    static {
        AssemblyProgramItem.PROGRAMS[AssemblyRecipe.AssemblyProgramType.DRILL.ordinal()] = new ProgramDrill();
        AssemblyProgramItem.PROGRAMS[AssemblyRecipe.AssemblyProgramType.LASER.ordinal()] = new ProgramLaser();
        AssemblyProgramItem.PROGRAMS[AssemblyRecipe.AssemblyProgramType.DRILL_LASER.ordinal()] = new ProgramDrillLaser();
    }
}

