/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PressureChamberValveBlock
extends AbstractPneumaticCraftBlock
implements IBlockPressureChamber,
PneumaticCraftEntityBlock {
    public PressureChamberValveBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PNCBlockStateProperties.FORMED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_6402_(Level par1World, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack iStack) {
        super.m_6402_(par1World, pos, state, par5EntityLiving, iStack);
        if (!par1World.f_46443_ && PressureChamberValveBlockEntity.checkIfProperlyFormed(par1World, pos)) {
            AdvancementTriggers.PRESSURE_CHAMBER.trigger((ServerPlayer)par5EntityLiving);
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PNCBlockStateProperties.FORMED});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.PRESSURE_CHAMBER_VALVE.get()).filter(te -> te.multiBlockSize > 0).map(te -> InteractionResult.SUCCESS).orElse(InteractionResult.PASS);
        }
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.PRESSURE_CHAMBER_VALVE.get()).map(te -> {
            if (te.multiBlockSize > 0) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)te, (BlockPos)pos);
            } else if (te.accessoryValves.size() > 0) {
                for (PressureChamberValveBlockEntity valve : te.accessoryValves) {
                    if (valve.multiBlockSize <= 0) continue;
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)valve, (BlockPos)valve.m_58899_());
                    break;
                }
            } else {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.SUCCESS);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.invalidateMultiBlock(world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private void invalidateMultiBlock(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, PressureChamberValveBlockEntity.class).ifPresent(teValve -> {
                if (teValve.multiBlockSize > 0) {
                    teValve.onMultiBlockBreak();
                } else if (teValve.accessoryValves.size() > 0) {
                    teValve.accessoryValves.stream().filter(valve -> valve.multiBlockSize > 0).findFirst().ifPresent(PressureChamberValveBlockEntity::onMultiBlockBreak);
                }
            });
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PressureChamberValveBlockEntity(pPos, pState);
    }
}

