/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final int FULL_BRIGHT = 0xF000F0;
    private static final float FULL_CIRCLE = (float)Math.PI * 2;
    private static final float STEP = 0.25132743f;

    public static int[] decomposeColor(int color) {
        int[] res = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public static float[] decomposeColorF(int color) {
        float[] res = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return res;
    }

    private static boolean drawSide(byte mask, Direction d1, Direction d2) {
        return (mask & 1 << d1.m_122411_() | mask & 1 << d2.m_122411_()) != 0;
    }

    public static RenderType renderFrame(PoseStack matrixStack, MultiBufferSource buffer, AABB aabb, float fw, float r, float g, float b, float a, int packedLightIn, Direction ... sides) {
        RenderType type = ModRenderTypes.BLOCK_FRAME;
        VertexConsumer builder = buffer.m_6299_(type);
        Matrix4f posMat = matrixStack.m_85850_().m_252922_();
        byte mask = 0;
        if (sides.length == 0) {
            mask = -1;
        } else {
            for (Direction d : sides) {
                mask = (byte)(mask | 1 << d.m_122411_());
            }
        }
        float x1 = (float)aabb.f_82288_;
        float y1 = (float)aabb.f_82289_;
        float z1 = (float)aabb.f_82290_;
        float x2 = (float)aabb.f_82291_;
        float y2 = (float)aabb.f_82292_;
        float z2 = (float)aabb.f_82293_;
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z1 - fw, x2 - fw, y1 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z1 - fw, x2 - fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z2 - fw, x2 - fw, y1 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z2 - fw, x2 - fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 + fw, x1 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y2 - fw, z1 + fw, x1 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 + fw, x2 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y2 - fw, z1 + fw, x2 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 - fw, x1 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 - fw, x2 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z2 - fw, x1 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z2 - fw, x2 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        return type;
    }

    private static void renderOffsetAABB(Matrix4f posMat, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a, int packedLightIn) {
        builder.m_252986_(posMat, x1, y2, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, -1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 0.0f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z2).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z2).m_85950_(r, g, b, a).m_5601_(0.0f, -1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y2, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z2).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y2, z2).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y2, z1).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x1, y1, z1).m_85950_(r, g, b, a).m_5601_(-1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z1).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z1).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y2, z2).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, x2, y1, z2).m_85950_(r, g, b, a).m_5601_(1.0f, 0.0f, 0.0f).m_85969_(packedLightIn).m_5752_();
    }

    public static float rotateMatrixForDirection(PoseStack matrixStack, Direction facing) {
        float yRotation;
        switch (facing) {
            case UP: {
                yRotation = 0.0f;
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, -1.0f, -1.0f);
                break;
            }
            case DOWN: {
                yRotation = 0.0f;
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                matrixStack.m_252880_(0.0f, -1.0f, 1.0f);
                break;
            }
            case NORTH: {
                yRotation = 0.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
                break;
            }
            case SOUTH: {
                yRotation = 180.0f;
                break;
            }
            default: {
                yRotation = 270.0f;
            }
        }
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(yRotation));
        return yRotation;
    }

    public static void renderProgressingLine3d(ProgressingLine prev, ProgressingLine line, float partialTick, PoseStack matrixStack, VertexConsumer builder, int color) {
        float[] cols = RenderUtils.decomposeColorF(color);
        Matrix4f posMat = matrixStack.m_85850_().m_252922_();
        float progress = line.getProgress();
        float lx1 = Mth.m_14179_((float)partialTick, (float)line.startX, (float)prev.startX);
        float ly1 = Mth.m_14179_((float)partialTick, (float)line.startY, (float)prev.startY);
        float lz1 = Mth.m_14179_((float)partialTick, (float)line.startZ, (float)prev.startZ);
        float lx2 = Mth.m_14179_((float)progress, (float)lx1, (float)Mth.m_14179_((float)partialTick, (float)line.endX, (float)prev.endX));
        float ly2 = Mth.m_14179_((float)progress, (float)ly1, (float)Mth.m_14179_((float)partialTick, (float)line.endY, (float)prev.endY));
        float lz2 = Mth.m_14179_((float)progress, (float)lz1, (float)Mth.m_14179_((float)partialTick, (float)line.endZ, (float)prev.endZ));
        RenderUtils.normalLine(builder, posMat, matrixStack.m_85850_().m_252943_(), lx1, ly1, lz1, lx2, ly2, lz2, cols[0], cols[1], cols[2], cols[3], false);
    }

    public static void renderRing(ProgressingLine line, ProgressingLine lastLine, PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTick, float rotationYaw, float rotationPitch, int color) {
        matrixStackIn.m_85836_();
        double renderProgress = Mth.m_14179_((float)partialTick, (float)lastLine.progress, (float)line.progress);
        matrixStackIn.m_85837_((double)(line.endX - line.startX) * renderProgress, (double)(line.endY - line.startY) * renderProgress, (double)(line.endZ - line.startZ) * renderProgress);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(rotationYaw - 90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(rotationPitch));
        VertexConsumer builder = bufferIn.m_6299_(ModRenderTypes.getLineLoops(1.0));
        int[] cols = RenderUtils.decomposeColor(0xFF000000 | color);
        double size = (1.0 + 4.0 * renderProgress) / 16.0;
        Matrix4f posMat = matrixStackIn.m_85850_().m_252922_();
        for (float i = 0.0f; i < (float)Math.PI * 2; i += 0.25132743f) {
            Vec3 v1 = new Vec3(0.0, (double)Mth.m_14031_((float)i) * size, (double)Mth.m_14089_((float)i) * size);
            Vec3 v2 = new Vec3(0.0, (double)Mth.m_14031_((float)(i + 0.25132743f)) * size, (double)Mth.m_14089_((float)(i + 0.25132743f)) * size);
            RenderUtils.posF(builder, posMat, 0.0, v1.m_7098_(), v1.m_7094_()).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_252939_(matrixStackIn.m_85850_().m_252943_(), 0.0f, (float)(v2.m_7098_() - v1.m_7098_()), (float)(v2.m_7094_() - v1.m_7094_())).m_5752_();
        }
        matrixStackIn.m_85849_();
    }

    public static void rotateToPlayerFacing(PoseStack matrixStack) {
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - Minecraft.m_91087_().f_91063_.m_109153_().m_90590_()));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f - Minecraft.m_91087_().f_91063_.m_109153_().m_90589_()));
    }

    public static void drawTexture(PoseStack matrixStack, VertexConsumer builder, int x, int y, int packedLightIn) {
        RenderUtils.drawTexture(matrixStack, builder, x, y, 0.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
    }

    public static void drawTexture(PoseStack matrixStack, VertexConsumer builder, int x, int y, float u1, float v1, float u2, float v2, int packedLightIn) {
        Matrix4f posMat = matrixStack.m_85850_().m_252922_();
        builder.m_252986_(posMat, (float)x, (float)(y + 16), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v2).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, (float)(x + 16), (float)(y + 16), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u2, v2).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, (float)(x + 16), (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u2, v1).m_85969_(packedLightIn).m_5752_();
        builder.m_252986_(posMat, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_85969_(packedLightIn).m_5752_();
    }

    public static VertexConsumer posF(VertexConsumer builder, Matrix4f posMat, double x, double y, double z) {
        return builder.m_252986_(posMat, (float)x, (float)y, (float)z);
    }

    public static void finishBuffer(MultiBufferSource buffer, RenderType type) {
        if (buffer instanceof MultiBufferSource.BufferSource) {
            RenderSystem.disableDepthTest();
            ((MultiBufferSource.BufferSource)buffer).m_109912_(type);
        }
    }

    public static void renderWithTypeAndFinish(PoseStack matrixStack, MultiBufferSource buffer, RenderType type, BiConsumer<Matrix4f, VertexConsumer> consumer) {
        consumer.accept(matrixStack.m_85850_().m_252922_(), buffer.m_6299_(type));
        RenderUtils.finishBuffer(buffer, type);
    }

    public static void renderWithType(PoseStack matrixStack, MultiBufferSource buffer, RenderType type, BiConsumer<Matrix4f, VertexConsumer> consumer) {
        consumer.accept(matrixStack.m_85850_().m_252922_(), buffer.m_6299_(type));
    }

    public static void renderString3d(Component str, float x, float y, int color, PoseStack matrixStack, MultiBufferSource buffer, boolean dropShadow, boolean disableDepthTest) {
        Font fr = Minecraft.m_91087_().f_91062_;
        fr.m_272077_(str, x, y, color, dropShadow, matrixStack.m_85850_().m_252922_(), buffer, disableDepthTest ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderString3d(FormattedCharSequence str, float x, float y, int color, PoseStack matrixStack, MultiBufferSource buffer, boolean dropShadow, boolean disableDepthTest) {
        Font fr = Minecraft.m_91087_().f_91062_;
        fr.m_272191_(str, x, y, color, dropShadow, matrixStack.m_85850_().m_252922_(), buffer, disableDepthTest ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void normalLine(VertexConsumer builder, Matrix4f posMat, Matrix3f normal, float x1, float y1, float z1, float x2, float y2, float z2, float a, float r, float g, float b, boolean isStrip) {
        float nx = x2 - x1;
        float ny = y2 - y1;
        float nz = z2 - z1;
        float d = Mth.m_14116_((float)(nx * nx + ny * ny + nz * nz));
        builder.m_252986_(posMat, x1, y1, z1).m_85950_(r, g, b, a).m_252939_(normal, nx / d, ny / d, nz / d).m_5752_();
        if (!isStrip) {
            builder.m_252986_(posMat, x2, y2, z2).m_85950_(r, g, b, a).m_252939_(normal, nx / d, ny / d, nz / d).m_5752_();
        }
    }
}

