/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.drone;

import com.mojang.blaze3d.vertex.PoseStack;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.drone.ModelDrone;
import me.desht.pneumaticcraft.client.render.entity.drone.DroneColourLayer;
import me.desht.pneumaticcraft.client.render.entity.drone.DroneDigLaserLayer;
import me.desht.pneumaticcraft.client.render.entity.drone.DroneHeldItemLayer;
import me.desht.pneumaticcraft.client.render.entity.drone.DroneMinigunLayer;
import me.desht.pneumaticcraft.client.render.entity.drone.DroneTargetLaserLayer;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class RenderDrone
extends MobRenderer<AbstractDroneEntity, ModelDrone> {
    private final ResourceLocation texture;
    private final float scale;

    private RenderDrone(EntityRendererProvider.Context ctx, float scale, ResourceLocation texture) {
        super(ctx, (EntityModel)new ModelDrone(ctx.m_174023_(PNCModelLayers.DRONE)), 0.25f);
        this.scale = scale;
        this.texture = texture;
        this.m_115326_(new DroneColourLayer((RenderLayerParent<AbstractDroneEntity, ModelDrone>)this));
        this.m_115326_(new DroneHeldItemLayer(this));
        this.m_115326_(new DroneDigLaserLayer((RenderLayerParent<AbstractDroneEntity, ModelDrone>)this));
        this.m_115326_(new DroneMinigunLayer(this));
        this.m_115326_(new DroneTargetLaserLayer(this));
    }

    public static RenderDrone standard(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.DRONE_ENTITY);
    }

    public static RenderDrone programmableController(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.25f, Textures.DRONE_ENTITY);
    }

    public static RenderDrone logistics(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.LOGISTICS_DRONE_ENTITY);
    }

    public static RenderDrone harvesting(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.HARVESTING_DRONE_ENTITY);
    }

    public static RenderDrone guard(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.GUARD_DRONE_ENTITY);
    }

    public static RenderDrone collector(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.COLLECTOR_DRONE_ENTITY);
    }

    public static RenderDrone amadrone(EntityRendererProvider.Context ctx) {
        return new RenderDrone(ctx, 0.35f, Textures.AMADRONE_ENTITY);
    }

    public void render(AbstractDroneEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(this.scale, this.scale, this.scale);
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(AbstractDroneEntity entity) {
        return this.texture;
    }
}

