/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.SolarCompressorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.SolarCompressorMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SolarCompressorScreen
extends AbstractPneumaticCraftContainerScreen<SolarCompressorMenu, SolarCompressorBlockEntity> {
    private WidgetTemperature tempWidget;

    public SolarCompressorScreen(SolarCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.tempWidget = new WidgetTemperature(this.f_97735_ + 97, this.f_97736_ + 20, TemperatureRange.of(223, 723), 273, 50).setOperatingRange(TemperatureRange.of(312, 723)).setShowOperatingRange(false);
        this.m_142416_((GuiEventListener)this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        if (((SolarCompressorBlockEntity)this.te).canGenerateAir()) {
            return Textures.GUI_SOLAR_COMPRESSOR_ACTIVE;
        }
        if (((SolarCompressorBlockEntity)this.te).isBroken()) {
            return Textures.GUI_SOLAR_COMPRESSOR_BROKEN;
        }
        return Textures.GUI_SOLAR_COMPRESSOR_INACTIVE;
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.tempWidget.setTemperature(((SolarCompressorBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((SolarCompressorBlockEntity)this.te).getAirRate(), 2)));
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((SolarCompressorBlockEntity)this.te).isBroken()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.solar_compressor.broken", new Object[0]));
        } else if (!((SolarCompressorBlockEntity)this.te).getCanSeeSunlight()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.solar_compressor.noSunlight", new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (((SolarCompressorBlockEntity)this.te).canGenerateAir()) {
            if (((SolarCompressorBlockEntity)this.te).getPercentHeatEfficiency() < 100) {
                curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.solar_compressor.efficiency", ((SolarCompressorBlockEntity)this.te).getPercentHeatEfficiency() + "%", 425));
            } else if ((double)((SolarCompressorBlockEntity)this.te).getTemperature() > 683.15) {
                curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.solar_compressor.overheat", 425));
            }
        }
    }
}

