/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AmadronScreen
extends AbstractPneumaticCraftContainerScreen<AmadronMenu, AbstractPneumaticCraftBlockEntity> {
    private static final int ROWS = 4;
    public static final int OFFERS_PER_PAGE = 8;
    private WidgetTextField searchBar;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetLabel pageLabel;
    private int page = 0;
    private final List<WidgetAmadronOfferAdjustable> offerWidgets = new ArrayList<WidgetAmadronOfferAdjustable>();
    private boolean needsRefreshing;
    private boolean hadProblem = false;
    private WidgetButtonExtended orderButton;
    private WidgetButtonExtended addTradeButton;
    private WidgetAnimatedStat customTradesTab;
    private boolean needTooltipUpdate = true;
    private int problemTimer = 0;

    public AmadronScreen(AmadronMenu container, Inventory inv, Component displayString) {
        super(container, inv, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 176;
        this.f_97727_ = 202;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        MutableComponent amadron = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.title", new Object[0]);
        this.addLabel((Component)amadron, this.f_97735_ + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)amadron) / 2, this.f_97736_ + 5, 0xFFFFFF).setDropShadow(true);
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.search", new Object[0]), this.f_97735_ + 76 - this.f_96547_.m_92895_(I18n.m_118938_((String)"pneumaticcraft.gui.search", (Object[])new Object[0])), this.f_97736_ + 41, 0xFFFFFF);
        this.addInfoTab((Component)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.amadron_tablet", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.ghostSlotInteraction.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16733441, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.ghostSlotInteraction", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer.title", new Object[0]), new ItemStack((ItemLike)Items.f_42614_), -16776961, true).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer", new Object[0]));
        this.customTradesTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.customTrades", new Object[0]), new ItemStack((ItemLike)Items.f_42415_), -3117056, false);
        this.customTradesTab.setMinimumExpandedDimensions(80, 50);
        Objects.requireNonNull(this.f_96547_);
        this.searchBar = new WidgetTextField(this.f_96547_, this.f_97735_ + 79, this.f_97736_ + 40, 73, 9);
        this.searchBar.m_94151_(s -> this.sendDelayed(8));
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_7522_((GuiEventListener)this.searchBar);
        this.scrollbar = new WidgetVerticalScrollbar(this.f_97735_ + 156, this.f_97736_ + 54, 142).setStates(1).setListening(true);
        this.m_142416_((GuiEventListener)this.scrollbar);
        this.orderButton = new WidgetButtonExtended(this.f_97735_ + 52, this.f_97736_ + 16, 72, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order", new Object[0])).withTag("order");
        this.m_142416_((GuiEventListener)this.orderButton);
        this.updateOrderButtonTooltip();
        this.addTradeButton = new WidgetButtonExtended(16, 26, 20, 20).withTag("addPlayerTrade").setRenderStacks(new ItemStack((ItemLike)Items.f_42616_));
        this.addTradeButton.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade", new Object[0]).m_130946_("\n").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip", new Object[0]))));
        this.customTradesTab.addSubWidget((AbstractWidget)this.addTradeButton);
        this.pageLabel = new WidgetLabel(this.f_97735_ + 158, this.f_97736_ + 49, (Component)Component.m_237113_((String)""));
        this.m_142416_((GuiEventListener)this.pageLabel);
        this.pageLabel.setScale(0.5f);
        this.pageLabel.setColor(-2039584);
        this.needsRefreshing = true;
    }

    public static void basketUpdated() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AmadronScreen) {
            AmadronScreen g = (AmadronScreen)screen;
            g.needTooltipUpdate = true;
        }
    }

    @Override
    protected void doDelayedAction() {
        this.needsRefreshing = true;
        this.scrollbar.setCurrentState(0);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.scrollbar.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    protected OptionalInt getBackgroundTint() {
        return OptionalInt.of(-16347604);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON;
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (this.needsRefreshing || this.page != this.scrollbar.getState()) {
            this.setPage(this.scrollbar.getState());
        }
        for (WidgetAmadronOfferAdjustable offerWidget : this.offerWidgets) {
            offerWidget.setAffordable(((AmadronMenu)this.f_97732_).affordableOffers[offerWidget.index]);
            offerWidget.setShoppingAmount(((AmadronMenu)this.f_97732_).getShoppingBasketUnits(offerWidget.getOffer().m_6423_()));
        }
        if (!this.hadProblem && ((AmadronMenu)this.f_97732_).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            this.problemTab.openStat();
        }
        this.hadProblem = ((AmadronMenu)this.f_97732_).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS;
        this.addTradeButton.f_93623_ = ((AmadronMenu)this.f_97732_).currentPlayerOffers < ((AmadronMenu)this.f_97732_).maxPlayerOffers;
        MutableComponent text = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip.offerCount", ((AmadronMenu)this.f_97732_).currentPlayerOffers, ((AmadronMenu)this.f_97732_).maxPlayerOffers == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(((AmadronMenu)this.f_97732_).maxPlayerOffers));
        this.customTradesTab.setText((Component)text);
        boolean bl = this.orderButton.f_93623_ = !((AmadronMenu)this.f_97732_).isBasketEmpty() && ((AmadronMenu)this.f_97732_).problemState == AmadronMenu.EnumProblemState.NO_PROBLEMS;
        if (this.needTooltipUpdate) {
            this.updateOrderButtonTooltip();
            this.needTooltipUpdate = false;
        }
        if (this.problemTimer == 0 && ((AmadronMenu)this.f_97732_).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            this.problemTimer = 70;
        } else if (this.problemTimer > 0 && --this.problemTimer <= 0) {
            ((AmadronMenu)this.f_97732_).problemState = AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }
    }

    private void updateOrderButtonTooltip() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order.tooltip", new Object[0]));
        if (!((AmadronMenu)this.f_97732_).isBasketEmpty()) {
            builder.add((Object)Component.m_237119_());
            builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.basket", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}));
            for (AmadronRecipe offer : AmadronOfferManager.getInstance().getActiveOffers()) {
                int nOrders = ((AmadronMenu)this.f_97732_).getShoppingBasketUnits(offer.m_6423_());
                if (nOrders <= 0) continue;
                String in = offer.getInput().getAmount() * nOrders + " x " + offer.getInput().getName();
                String out = offer.getOutput().getAmount() * nOrders + " x " + offer.getOutput().getName();
                builder.add((Object)Component.m_237113_((String)("\u2022 " + String.valueOf(ChatFormatting.YELLOW) + out)));
                builder.add((Object)Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + "   for " + String.valueOf(ChatFormatting.YELLOW) + in)));
            }
        }
        Component c = PneumaticCraftUtils.combineComponents((List<Component>)builder.build());
        this.orderButton.m_257544_(Tooltip.m_257550_((Component)c));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ClientUtils.getClientPlayer().m_6915_();
        }
        return this.searchBar.m_7933_(keyCode, scanCode, modifiers) || this.searchBar.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateVisibleOffers();
        int nPages = (((AmadronMenu)this.f_97732_).activeOffers.size() - 1) / 8 + 1;
        this.pageLabel.m_93666_((Component)Component.m_237113_((String)(page + 1 + "/" + nPages)));
    }

    private void updateVisibleOffers() {
        AmadronRecipe offer;
        int i;
        this.needsRefreshing = false;
        ArrayList<AmadronRecipe> visibleOffers = new ArrayList<AmadronRecipe>();
        int skippedOffers = 0;
        int applicableOffers = 0;
        for (i = 0; i < ((AmadronMenu)this.f_97732_).activeOffers.size(); ++i) {
            offer = ((AmadronMenu)this.f_97732_).activeOffers.get(i);
            if (!offer.passesQuery(this.searchBar.m_94155_())) continue;
            ++applicableOffers;
            if (skippedOffers < this.page * 8) {
                ++skippedOffers;
                continue;
            }
            if (visibleOffers.size() >= 8) continue;
            visibleOffers.add(offer);
        }
        this.scrollbar.setStates(Math.max(1, (applicableOffers + 8 - 1) / 8 - 1));
        this.offerWidgets.forEach(this::removeWidget);
        this.offerWidgets.clear();
        for (i = 0; i < visibleOffers.size(); ++i) {
            offer = (AmadronRecipe)visibleOffers.get(i);
            int idx = ((AmadronMenu)this.f_97732_).activeOffers.indexOf(offer);
            if (idx < 0) continue;
            WidgetAmadronOfferAdjustable widget = new WidgetAmadronOfferAdjustable(this.f_97735_ + 6 + 73 * (i % 2), this.f_97736_ + 55 + 35 * (i / 2), offer, idx);
            this.m_142416_((GuiEventListener)widget);
            this.offerWidgets.add(widget);
        }
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((AmadronMenu)this.f_97732_).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((AmadronMenu)this.f_97732_).problemState.getTranslationKey(), new Object[0]));
        }
    }

    @Override
    public void onGuiUpdate() {
        this.needTooltipUpdate = true;
    }

    static class WidgetAmadronOfferAdjustable
    extends WidgetAmadronOffer {
        private final int index;

        WidgetAmadronOfferAdjustable(int x, int y, AmadronRecipe offer, int index) {
            super(x, y, offer);
            this.index = index;
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            if (super.m_6375_(mouseX, mouseY, mouseButton)) {
                return true;
            }
            if (this.m_93680_(mouseX, mouseY) && this.getOffer().isUsableByPlayer(ClientUtils.getClientPlayer())) {
                NetworkHandler.sendToServer(new PacketAmadronOrderUpdate(this.getOffer().m_6423_(), mouseButton, Screen.m_96638_()));
                return true;
            }
            return false;
        }
    }
}

