/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.IGuiDrone;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof BucketItem) {
            TooltipEventHandler.handleFluidContainerTooltip(event);
        } else if (PneumaticCraftUtils.getRegistryName(stack.m_41720_()).orElseThrow().m_135827_().equals("pneumaticcraft") || stack.m_204117_(PneumaticCraftTags.Items.PNC_TOOLTIP)) {
            TooltipEventHandler.addStandardTooltip(stack, event.getToolTip(), event.getFlags());
        }
        if (stack.m_41720_() instanceof IProgrammable) {
            TooltipEventHandler.handleProgrammableTooltip(event);
        }
    }

    private static void addStandardTooltip(ItemStack stack, List<Component> curInfo, TooltipFlag flagIn) {
        String key;
        TooltipEventHandler.addPressureTooltip(stack, curInfo);
        UpgradableItemUtils.addUpgradeInformation(stack, curInfo, flagIn);
        Item item = stack.m_41720_();
        if (item instanceof IInventoryItem) {
            IInventoryItem item2 = (IInventoryItem)item;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            item2.getStacksInItem(stack, stacks);
            if (item2.getInventoryHeader() != null && !stacks.isEmpty()) {
                curInfo.add(item2.getInventoryHeader());
            }
            PneumaticCraftUtils.summariseItemStacks(curInfo, stacks, Component.m_237113_((String)item2.getTooltipPrefix(stack)));
        }
        if (I18n.m_118936_((String)(key = ICustomTooltipName.getTranslationKey(stack, true)))) {
            if (ClientUtils.hasShiftDown()) {
                String translatedInfo = String.valueOf(ChatFormatting.AQUA) + I18n.m_118938_((String)key, (Object[])new Object[0]);
                curInfo.addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
                    curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.installDocsProvider", new Object[0]));
                }
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).m_130940_(ChatFormatting.AQUA));
            }
        }
    }

    private static void addPressureTooltip(ItemStack stack, List<Component> textList) {
        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            ChatFormatting color = f < 0.1f ? ChatFormatting.RED : (f < 0.5f ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 1)).m_130940_(color));
        });
    }

    private static void handleProgrammableTooltip(ItemTooltipEvent event) {
        IProgrammable programmable = (IProgrammable)event.getItemStack().m_41720_();
        if (programmable.canProgram(event.getItemStack()) && programmable.showProgramTooltip()) {
            boolean hasInvalidPrograms = false;
            ArrayList<Object> addedEntries = new ArrayList<Object>();
            List<IProgWidget> widgets = ProgrammerBlockEntity.getProgWidgets(event.getItemStack());
            Map<ResourceLocation, Integer> widgetMap = TooltipEventHandler.getPuzzleSummary(widgets);
            for (Map.Entry<ResourceLocation, Integer> entry : widgetMap.entrySet()) {
                ChatFormatting[] prefix = new ChatFormatting[]{};
                ProgWidgetType widgetType = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(entry.getKey());
                if (widgetType == null) continue;
                Screen curScreen = Minecraft.m_91087_().f_91080_;
                if (curScreen instanceof IGuiDrone && !((IGuiDrone)curScreen).getDrone().isProgramApplicable(widgetType)) {
                    prefix = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
                    hasInvalidPrograms = true;
                }
                addedEntries.add(Component.m_237113_((String)("\u2022 " + String.valueOf(entry.getValue()) + " x ")).m_7220_((Component)PneumaticCraftUtils.xlate(widgetType.getTranslationKey(), new Object[0])).m_130944_(prefix));
            }
            if (hasInvalidPrograms) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.invalidPieces", new Object[0]).m_130940_(ChatFormatting.RED));
            }
            addedEntries.sort(Comparator.comparing(Component::getString));
            event.getToolTip().addAll(addedEntries);
            if (ClientUtils.hasShiftDown() && !widgets.isEmpty()) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.requiredPieces", widgets.size()).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    private static void handleFluidContainerTooltip(ItemTooltipEvent event) {
        FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fluidStack -> {
            String key = ICustomTooltipName.getTranslationKey(event.getItemStack(), true);
            if (I18n.m_118936_((String)key)) {
                if (Screen.m_96638_()) {
                    String translatedInfo = String.valueOf(ChatFormatting.AQUA) + I18n.m_118938_((String)key, (Object[])new Object[0]);
                    event.getToolTip().addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                } else {
                    event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).m_130940_(ChatFormatting.AQUA));
                }
            }
        });
    }

    private static Map<ResourceLocation, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
        for (IProgWidget widget : widgets) {
            map.put(widget.getTypeID(), map.getOrDefault(widget.getTypeID(), 0) + 1);
        }
        return map;
    }

    @SubscribeEvent
    public static void gatherComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof MicromissilesItem && stack.m_41782_() && MicromissilesItem.getFireMode(stack) == MicromissilesItem.FireMode.SMART) {
            event.getTooltipElements().add(Either.right((Object)new MicromissilesItem.Tooltip(stack)));
        }
    }
}

