/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.pneumatic_armor.hacking;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

public interface IHackableEntity<T extends Entity> {
    @Nonnull
    public ResourceLocation getHackableId();

    @Nonnull
    public Class<T> getHackableClass();

    default public boolean canHack(Entity entity, Player player) {
        return entity.m_6084_() && this.getHackableClass().isAssignableFrom(entity.getClass());
    }

    public void addHackInfo(T var1, List<Component> var2, Player var3);

    public void addPostHackInfo(T var1, List<Component> var2, Player var3);

    public int getHackTime(T var1, Player var2);

    public void onHackFinished(T var1, Player var2);

    default public boolean afterHackTick(T entity) {
        return false;
    }

    @ApiStatus.Internal
    default public boolean _afterHackTick(Entity e) {
        return this.getHackableClass().isAssignableFrom(e.getClass()) && this.afterHackTick(e);
    }

    @ApiStatus.Internal
    default public int _getHackTime(Entity e, Player p) {
        return this.getHackableClass().isAssignableFrom(e.getClass()) ? this.getHackTime(e, p) : -1;
    }

    @ApiStatus.Internal
    default public void _onHackFinished(Entity e, Player p) {
        if (this.getHackableClass().isAssignableFrom(e.getClass())) {
            this.onHackFinished(e, p);
        }
    }

    @ApiStatus.Internal
    default public void _addHackInfo(Entity e, List<Component> componentList, Player p) {
        if (this.getHackableClass().isAssignableFrom(e.getClass())) {
            this.addHackInfo(e, componentList, p);
        }
    }

    @ApiStatus.Internal
    default public void _addPostHackInfo(Entity e, List<Component> componentList, Player p) {
        if (this.getHackableClass().isAssignableFrom(e.getClass())) {
            this.addPostHackInfo(e, componentList, p);
        }
    }
}

