/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn;

import com.frikinjay.almanac.Almanac;
import com.frikinjay.letmedespawn.command.LetMeDespawnCommands;
import com.frikinjay.letmedespawn.config.LetMeDespawnConfig;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public final class LetMeDespawn {
    public static final String MOD_ID = "letmedespawn";
    public static final Logger logger = LogUtils.getLogger();
    public static final File CONFIG_FILE = new File("config/letmedespawn.json");
    public static LetMeDespawnConfig config;

    public static void init() {
        config = LetMeDespawnConfig.load();
        Almanac.addConfigChangeListener((File)CONFIG_FILE, newConfig -> {
            config = (LetMeDespawnConfig)newConfig;
            logger.info("LetMeDespawn config reloaded");
        });
        config.save();
        Almanac.addCommandRegistration(LetMeDespawnCommands::register);
    }

    public static void setPersistence(Mob entity, EquipmentSlot slot) {
        ItemStack itemStack = entity.m_6844_(slot);
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128379_("picked", true);
        Almanac.pickedItems = true;
        entity.f_21353_ = config.getMobNames().contains(entity.m_9236_().m_9598_().m_175515_(Registries.f_256939_).m_7981_((Object)entity.m_6095_()).toString()) || !LetMeDespawn.hasDespawnableName(entity);
    }

    public static boolean hasDespawnableName(Mob entity) {
        if (entity.m_8077_()) {
            return Almanac.matchesStackedName((String)entity.m_7770_().getString(), (Entity)entity);
        }
        return true;
    }
}

