/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.player.ETFPlayerSkinHolder;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFPlayerFeatureRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    protected static final ModelPart villagerNose = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).m_171576_().m_171597_("nose").m_171583_(64, 64);
    protected static final ModelPart textureNose = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).m_171576_().m_171597_("textureNose").m_171583_(8, 8);
    protected static final ModelPart jacket = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).m_171576_().m_171597_("jacket").m_171583_(64, 64);
    protected static final ModelPart fatJacket = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).m_171576_().m_171597_("fatJacket").m_171583_(64, 64);
    private static final ResourceLocation VILLAGER_TEXTURE = ETFUtils2.res("textures/entity/villager/villager.png");
    protected final ETFPlayerSkinHolder skinHolder;

    public ETFPlayerFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
        ETFPlayerSkinHolder holder;
        this.skinHolder = context instanceof ETFPlayerSkinHolder ? (holder = (ETFPlayerSkinHolder)context) : null;
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 12.5f, -2.0f, 8.0f, 12.0f, 4.0f, dilation.m_171469_(0.25f)), PartPose.f_171404_);
        modelPartData.m_171599_("fatJacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 12.5f, -2.0f, 8.0f, 12.0f, 4.0f, dilation.m_171469_(0.25f).m_171469_(0.5f)), PartPose.f_171404_);
        modelPartData.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        modelPartData.m_171599_("textureNose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -8.0f, -8.0f, 0.0f, 8.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        return modelData;
    }

    public static void renderSkullFeatures(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, SkullModelBase skullModel, ETFPlayerTexture playerTexture, float yaw) {
        ETFRenderContext.preventRenderLayerTextureModify();
        ETFRenderContext.startSpecialRenderOverlayPhase();
        if (playerTexture.hasVillagerNose || playerTexture.texturedNoseIdentifier != null) {
            ETFPlayerFeatureRenderer.villagerNose.f_104204_ = yaw * ((float)Math.PI / 180);
            ETFPlayerFeatureRenderer.villagerNose.f_104203_ = 0.0f;
            ETFPlayerFeatureRenderer.villagerNose.f_104201_ = 0.0f;
            ETFPlayerFeatureRenderer.textureNose.f_104204_ = yaw * ((float)Math.PI / 180);
            ETFPlayerFeatureRenderer.textureNose.f_104203_ = 0.0f;
            ETFPlayerFeatureRenderer.textureNose.f_104201_ = 0.0f;
            ETFPlayerFeatureRenderer.renderNose(matrixStack, vertexConsumerProvider, light, playerTexture);
        }
        ETFPlayerFeatureRenderer.renderEnchanted(matrixStack, vertexConsumerProvider, light, playerTexture, (Model)skullModel);
        ETFRenderContext.endSpecialRenderOverlayPhase();
        ETFRenderContext.allowRenderLayerTextureModify();
    }

    private static void renderEnchanted(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, ETFPlayerTexture playerTexture, Model model) {
        if (playerTexture.hasEnchant && playerTexture.baseEnchantIdentifier != null && playerTexture.etfTextureOfFinalBaseSkin != null) {
            VertexConsumer enchantVert = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)(switch (playerTexture.etfTextureOfFinalBaseSkin.currentTextureState) {
                case ETFTexture.TextureReturnState.BLINK, ETFTexture.TextureReturnState.BLINK_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK -> playerTexture.baseEnchantBlinkIdentifier;
                case ETFTexture.TextureReturnState.BLINK2, ETFTexture.TextureReturnState.BLINK2_PATCHED, ETFTexture.TextureReturnState.APPLY_BLINK2 -> playerTexture.baseEnchantBlink2Identifier;
                default -> playerTexture.baseEnchantIdentifier;
            })), (boolean)false, (boolean)true);
            model.m_7695_(matrixStack, enchantVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static void renderNose(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, ETFPlayerTexture playerTexture) {
        if (playerTexture.hasVillagerNose) {
            if (playerTexture.noseType == ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED || playerTexture.noseType == ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED_REMOVE) {
                VertexConsumer villagerVert = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)playerTexture.etfTextureOfFinalBaseSkin.getTextureIdentifier(null)));
                villagerNose.m_104306_(matrixStack, villagerVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                playerTexture.etfTextureOfFinalBaseSkin.renderEmissive(matrixStack, vertexConsumerProvider, villagerNose);
            } else {
                VertexConsumer villagerVert = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)VILLAGER_TEXTURE));
                villagerNose.m_104306_(matrixStack, villagerVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (playerTexture.texturedNoseIdentifier != null) {
            VertexConsumer noseVertex = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)playerTexture.texturedNoseIdentifier));
            textureNose.m_104306_(matrixStack, noseVertex, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (playerTexture.texturedNoseIdentifierEmissive != null) {
                VertexConsumer noseVertex_e = ETFManager.getEmissiveMode() == ETFConfig.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)playerTexture.texturedNoseIdentifierEmissive, (boolean)true)) : vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)playerTexture.texturedNoseIdentifierEmissive));
                textureNose.m_104306_(matrixStack, noseVertex_e, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (playerTexture.texturedNoseIdentifierEnchanted != null) {
                VertexConsumer noseVertex_ench = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)playerTexture.texturedNoseIdentifierEnchanted), (boolean)false, (boolean)true);
                textureNose.m_104306_(matrixStack, noseVertex_ench, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (ETF.config().getConfig().skinFeaturesEnabled && this.skinHolder != null) {
            ETFRenderContext.preventRenderLayerTextureModify();
            ETFPlayerTexture playerTexture = this.skinHolder.etf$getETFPlayerTexture();
            if (playerTexture != null && playerTexture.hasFeatures) {
                this.renderFeatures(matrices, vertexConsumers, light, (PlayerModel)this.m_117386_(), playerTexture);
            }
            ETFRenderContext.allowRenderLayerTextureModify();
        }
    }

    public void renderFeatures(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, M model, ETFPlayerTexture playerTexture) {
        if (playerTexture.canUseFeaturesForThisPlayer()) {
            ETFRenderContext.startSpecialRenderOverlayPhase();
            if (playerTexture.hasVillagerNose || playerTexture.texturedNoseIdentifier != null) {
                villagerNose.m_104315_(((PlayerModel)model).f_102808_);
                textureNose.m_104315_(((PlayerModel)model).f_102808_);
                ETFPlayerFeatureRenderer.renderNose(matrixStack, vertexConsumerProvider, light, playerTexture);
            }
            this.renderCoat(matrixStack, vertexConsumerProvider, light, playerTexture, model);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    private void renderCoat(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, ETFPlayerTexture playerTexture, M model) {
        ItemStack armour = playerTexture.player.etf$getInventory().m_36052_(1);
        if (!(playerTexture.coatIdentifier == null || !playerTexture.player.etf$isPartVisible(PlayerModelPart.JACKET) || armour.m_150930_(Items.f_42466_) || armour.m_150930_(Items.f_42462_) || armour.m_150930_(Items.f_42474_) || armour.m_150930_(Items.f_42478_) || armour.m_150930_(Items.f_42470_) || armour.m_150930_(Items.f_42482_))) {
            if (playerTexture.hasFatCoat) {
                fatJacket.m_104315_(((PlayerModel)model).f_103378_);
            } else {
                jacket.m_104315_(((PlayerModel)model).f_103378_);
            }
            VertexConsumer coatVert = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)playerTexture.coatIdentifier));
            matrixStack.m_85836_();
            if (playerTexture.hasFatCoat) {
                fatJacket.m_104306_(matrixStack, coatVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                jacket.m_104306_(matrixStack, coatVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (playerTexture.coatEnchantedIdentifier != null) {
                VertexConsumer enchantVert = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)playerTexture.coatEnchantedIdentifier), (boolean)false, (boolean)true);
                if (playerTexture.hasFatCoat) {
                    fatJacket.m_104306_(matrixStack, enchantVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    jacket.m_104306_(matrixStack, enchantVert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (playerTexture.coatEmissiveIdentifier != null) {
                VertexConsumer emissiveVert = ETFManager.getEmissiveMode() == ETFConfig.EmissiveRenderModes.BRIGHT ? vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)playerTexture.coatEmissiveIdentifier, (boolean)true)) : vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)playerTexture.coatEmissiveIdentifier));
                if (playerTexture.hasFatCoat) {
                    fatJacket.m_104306_(matrixStack, emissiveVert, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    jacket.m_104306_(matrixStack, emissiveVert, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            matrixStack.m_85849_();
        }
    }
}

