/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.thermal;

import cofh.lib.common.block.CropBlockCoFH;
import cofh.lib.common.block.CropBlockMushroom;
import cofh.lib.util.helpers.MathHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.thermal.CropBlockCoFHAccessor;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.thermal.MushroomFruit;
import steve_gall.minecolonies_compatibility.module.common.thermal.PerennialCrop;

public class ThermalModule
extends AbstractModule {
    @Override
    protected void onFMLCommonSetup(FMLCommonSetupEvent e) {
        super.onFMLCommonSetup(e);
        e.enqueueWork(() -> {
            CustomizedCrop.register(new PerennialCrop());
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                if (!(block instanceof CropBlockMushroom)) continue;
                CropBlockMushroom mushroom = (CropBlockMushroom)block;
                CustomizedFruit.register(new MushroomFruit(mushroom));
            }
        });
    }

    public static List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState state = context.getState();
            CropBlockCoFH block = (CropBlockCoFH)state.m_60734_();
            CropBlockCoFHAccessor accessor = (CropBlockCoFHAccessor)block;
            int postHarvestAge = accessor.invokeGetPostHarvestAge();
            if (postHarvestAge >= 0) {
                int fortune = 0;
                ItemStack drop = new ItemStack(accessor.invokeGetCropItem(), 2 + MathHelper.binomialDist((int)fortune, (double)0.5));
                level.m_7731_(context.getPosition(), block.m_52289_(postHarvestAge), 2);
                return Collections.singletonList(drop);
            }
            List<ItemStack> drops = context.getDrops(harvester);
            PlantBlockContext.replant(context, drops, block.m_52289_(0));
            return drops;
        }
        return Collections.emptyList();
    }
}

