/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.jade;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;

public class PostBoxRequestedComponentProvider
implements IBlockComponentProvider {
    public static final ResourceLocation UID = MineColoniesCompatibility.rl("postbox.requested");
    public static final PostBoxRequestedComponentProvider INSTANCE = new PostBoxRequestedComponentProvider();

    private PostBoxRequestedComponentProvider() {
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public boolean isRequired() {
        return true;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
        if (!pluginConfig.get(UID)) {
            return;
        }
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding postBox = (TileEntityColonyBuilding)blockEntity;
            IBuildingView building = postBox.getBuildingView();
            if (building == null) {
                return;
            }
            ImmutableList requests = building.getOpenRequestsOfBuilding();
            if (requests.size() > 0) {
                tooltip.add((Component)Component.m_237115_((String)"minecolonies_compatibility.text.delivery_requested"));
                for (IRequest request : requests) {
                    tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_(request.getShortDisplayString()));
                }
            }
        }
    }
}

