/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.fruitfulfun;

import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class FruitfulFunFruit
extends CustomizedFruit {
    private final FruitLeavesBlock leaves;
    private final ResourceLocation id;
    private final List<ItemStack> blockIcons;
    private final List<ItemStack> itemIcons;

    public FruitfulFunFruit(FruitLeavesBlock leaves) {
        this.leaves = leaves;
        FruitType type = (FruitType)leaves.type.get();
        this.id = ForgeRegistries.BLOCKS.getKey((Object)this.leaves);
        this.blockIcons = Arrays.asList(new ItemStack((ItemLike)type.sapling.get()), new ItemStack((ItemLike)this.leaves));
        this.itemIcons = Arrays.asList(new ItemStack((ItemLike)type.fruit.get()));
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return this.blockIcons;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60713_((Block)this.leaves);
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)BlockStateProperties.f_61407_) == 3;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState newState = context.getState().m_60734_().m_49966_();
            level.m_7731_(context.getPosition(), newState, 2);
        }
        return Arrays.asList(((Item)((FruitType)this.leaves.type.get()).fruit.get()).m_7968_());
    }
}

