/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.ReadOnlySlotsContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingTeachMenu
extends TeachRecipeMenu<CuttingBoardRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 1;
    public static final int CRAFTING_COLS = 1;
    public static final int CRAFTING_X = 14;
    public static final int CRAFTING_Y = 36;
    public static final int RESULT_X = 73;
    public static final int RESULT_Y = 18;
    public static final int RESULT_COLUMNS = 5;
    private final EquipmentTypeEntry toolType;
    private List<ChanceResult> results;

    public CuttingTeachMenu(int windowId, Inventory inventory, IBuildingModule module, EquipmentTypeEntry toolType) {
        super((MenuType)ModuleMenuTypes.CUTTING_TEACH.get(), windowId, inventory, module);
        this.toolType = toolType;
        this.setup();
    }

    public CuttingTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.CUTTING_TEACH.get(), windowId, inventory, buffer);
        this.toolType = (EquipmentTypeEntry)buffer.readRegistryIdUnsafe(IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry());
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 1);
        for (int i2 = 0; i2 < 1; ++i2) {
            int col = i2 % 1;
            int row = i2 / 1;
            this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, i2, 14 + col * 18, 36 + row * 18)));
        }
        this.results = new ArrayList<ChanceResult>();
        this.resultContainer = new ReadOnlySlotsContainer(this.results::size, i -> this.results.get(i).getStack());
    }

    @Override
    protected IMenuRecipeValidator<CuttingBoardRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CuttingBoardRecipe, RecipeWrapper>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<CuttingBoardRecipe> getRecipeType() {
                return (RecipeType)ModRecipeTypes.CUTTING.get();
            }

            @Override
            protected boolean test(CuttingBoardRecipe recipe, Container container, ServerPlayer player) {
                return recipe.matches(new RecipeWrapper((IItemHandlerModifiable)new InvWrapper(container)), this.level);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull CuttingBoardRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        this.inputContainer.m_6836_(0, ItemStack.m_41712_((CompoundTag)payload.m_128469_("input")));
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        int prevSlots = this.resultSlots.size();
        this.results.clear();
        if (this.recipe != null) {
            this.results.addAll((Collection<ChanceResult>)((CuttingBoardRecipe)this.recipe).getRollableResults());
        }
        int addingSlots = this.results.size() - prevSlots;
        for (int i = 0; i < addingSlots; ++i) {
            int index = prevSlots + i;
            int xi = index % 5;
            int yi = index / 5;
            int x = 73 + xi * 18;
            int y = 18 + yi * 18;
            this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, index, x, y){

                public boolean m_6659_() {
                    return !this.m_7993_().m_41619_();
                }
            }));
        }
    }

    @Override
    @Nullable
    public Component getRecipeError(@NotNull CuttingBoardRecipe recipe) {
        if (!IngredientHelper.isTool(recipe.getTool(), this.getToolType())) {
            return Component.m_237115_((String)"minecolonies_compatibility.text.unsupported_tool");
        }
        boolean anyPrimary = recipe.getRollableResults().stream().anyMatch(r -> (double)r.getChance() >= 1.0);
        if (!anyPrimary) {
            return Component.m_237115_((String)"minecolonies_compatibility.text.no_primary_result_item");
        }
        return super.getRecipeError(recipe);
    }

    public EquipmentTypeEntry getToolType() {
        return this.toolType;
    }

    public List<ChanceResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

