/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.cyclic;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.cyclic.AppleCropBlockAccessor;

public class AppleSproutFruit
extends CustomizedFruit {
    private final RegistryObject<Block> sprout;
    private final Supplier<Item> fruit;

    public AppleSproutFruit(RegistryObject<Block> sprout, Supplier<Item> fruit) {
        this.sprout = sprout;
        this.fruit = fruit;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.sprout.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.sprout.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.fruit.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == this.sprout.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)AppleCropBlockAccessor.getAge()) >= AppleCropBlockAccessor.getMaxAge();
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        List<ItemStack> drops = context.getDrops(harvester);
        BlockState newState = context.getState().m_60734_().m_49966_();
        PlantBlockContext.replant(context, drops, newState);
        return drops;
    }
}

