/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchersdelight;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.module.common.butchersdelight.ButchersDelightModule;

public abstract class AbstractButcherable
extends CustomizedButcherable {
    protected final ResourceLocation id;
    protected final Item item;
    protected final Set<Block> blocks;
    protected final List<ItemStack> itemIcons;
    protected final List<Ingredient> outputIcons;

    public AbstractButcherable(Builder builder) {
        this.id = ForgeRegistries.ITEMS.getKey((Object)builder.item);
        this.item = builder.item;
        this.blocks = builder.blocks.stream().collect(Collectors.toUnmodifiableSet());
        this.itemIcons = Collections.singletonList(new ItemStack((ItemLike)builder.item));
        this.outputIcons = builder.outputs.stream().map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList();
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    @NotNull
    public List<Ingredient> getOutputIcons() {
        return this.outputIcons;
    }

    @Override
    @NotNull
    public ToolOrIngredientStack getTableTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        return ToolOrIngredientStack.EMPTY;
    }

    @Override
    public boolean testItem(@NotNull ItemStack item) {
        return item.m_150930_(this.item);
    }

    @Override
    public boolean isButcheringBlock(@NotNull ButcherBlockContext context) {
        return this.blocks.contains(context.getState().m_60734_());
    }

    @Override
    public void doButcherBlock(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        super.doButcherBlock(context, citizen);
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            ItemStack tool = this.getButcherBlockTool();
            this.setButcherBlockProcess(serverLevel.m_7702_(context.getPosition()).getPersistentData());
            ButchersDelightModule.rightClick(serverLevel, context.getPosition(), citizen.getWorker(), tool.m_41777_());
            CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)citizen.getWorker(), (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
        }
    }

    protected abstract void setButcherBlockProcess(CompoundTag var1);

    protected abstract ItemStack getButcherBlockTool();

    public Item getItem() {
        return this.item;
    }

    public Set<Block> getBlocks() {
        return this.blocks;
    }

    public static class Builder {
        private Item item = Items.f_41852_;
        private final List<Block> blocks = new ArrayList<Block>();
        private final List<ItemStack> outputs = new ArrayList<ItemStack>();

        public Builder item(Item item) {
            this.item = item;
            return this;
        }

        public Builder item(Supplier<Item> item) {
            return this.item(item.get());
        }

        public Builder block(Block block) {
            this.blocks.add(block);
            return this;
        }

        public Builder block(Supplier<Block> block) {
            return this.block(block.get());
        }

        public Builder output(Item output) {
            return this.output(new ItemStack((ItemLike)output));
        }

        public Builder output(Supplier<Item> output) {
            return this.output(output.get());
        }

        public Builder output(ItemStack output) {
            this.outputs.add(output);
            return this;
        }
    }
}

