/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.building.module;

import com.lance5057.butchercraft.workstations.grinder.GrinderBlockEntity;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.building.module.AbstractCraftingModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.core.common.util.InteractionMessageHelper;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.crafting.GrinderRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.init.ModuleCraftingTypes;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class GrinderCraftingModule
extends AbstractCraftingModuleWithExternalWorkingBlocks {
    public GrinderCraftingModule(JobEntry jobEntry) {
        super(jobEntry);
    }

    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
    }

    @Override
    public boolean isWorkingBlock(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return level.m_7702_(pos) instanceof GrinderBlockEntity;
    }

    @Override
    public boolean canBlockRecipeWorking(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IRecipeStorage recipeStorage) {
        BlockEntity blockEntity;
        GrinderRecipeStorage recipe = GrinderCraftingModule.toRecipe(recipeStorage);
        if (recipe != null && (blockEntity = level.m_7702_(pos)) instanceof GrinderBlockEntity) {
            GrinderBlockEntity grinder = (GrinderBlockEntity)blockEntity;
            return ItemStack.m_41656_((ItemStack)recipe.getAttachment().getItemStack(), (ItemStack)grinder.getAttachment());
        }
        return false;
    }

    @NotNull
    public String getId() {
        return "butchercraft_grinder";
    }

    public Set<CraftingType> getSupportedCraftingTypes() {
        return Collections.singleton((CraftingType)ModuleCraftingTypes.GRINDER.get());
    }

    public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
        return true;
    }

    @Override
    @NotNull
    public Component getWorkingBlockNotFoundMessage(@NotNull IRecipeStorage recipeStorage) {
        GrinderRecipeStorage recipe = GrinderCraftingModule.toRecipe(recipeStorage);
        if (recipe == null) {
            return super.getWorkingBlockNotFoundMessage(recipeStorage);
        }
        Block block = recipeStorage.getIntermediate();
        String modDisplayName = InteractionMessageHelper.getModDisplayName(block);
        ItemStack attachment = recipe.getAttachment().getItemStack();
        return Component.m_237110_((String)"minecolonies_compatibility.interaction.no_butchercraft_grinder_with_attachment", (Object[])new Object[]{modDisplayName, block.m_49954_(), attachment.m_41786_()});
    }

    public static GrinderRecipeStorage toRecipe(IToken<?> token) {
        return GrinderCraftingModule.toRecipe(IColonyManager.getInstance().getRecipeManager().getRecipe(token));
    }

    public static GrinderRecipeStorage toRecipe(IRecipeStorage recipeStorage) {
        ICustomizableRecipeStorage crs;
        ICustomizedRecipeStorage iCustomizedRecipeStorage;
        if (recipeStorage instanceof ICustomizableRecipeStorage && (iCustomizedRecipeStorage = (crs = (ICustomizableRecipeStorage)recipeStorage).getImpl()) instanceof GrinderRecipeStorage) {
            GrinderRecipeStorage recipe = (GrinderRecipeStorage)iCustomizedRecipeStorage;
            return recipe;
        }
        return null;
    }
}

