/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.ConfigManager;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.block.entity.BlockEntityExtension;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.module.common.ae2.init.ModuleMenuTypes;

public class CitizenTerminalPart
extends AbstractDisplayPart
implements IStorageWatcherNode,
IGridTickable,
IConfigurableObject {
    @PartModels
    public static final ResourceLocation MODEL_OFF = MineColoniesCompatibility.rl("part/citizen_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = MineColoniesCompatibility.rl("part/citizen_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    private static final String TAG_LINK = "link";
    private final StorageView view = new StorageView();
    private final KeyCounter counter = new KeyCounter();
    private final IActionSource action = IActionSource.ofMachine((IActionHost)this);
    private final IConfigManager config = new ConfigManager(this::onSettingChanged);

    public CitizenTerminalPart(IPartItem<?> partItem) {
        super(partItem, false);
        this.config.registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        IManagedGridNode mainNode = this.getMainNode();
        mainNode.addService(IStorageWatcherNode.class, (IGridNodeService)this);
        mainNode.addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
        this.view.requestAll();
    }

    public boolean hasPermission() {
        NetworkStorageModule module = this.view.getLinkedModule();
        IGrid grid = this.getMainNode().getGrid();
        return module != null && grid != null;
    }

    public void removeFromWorld() {
        BlockEntityExtension bee;
        super.removeFromWorld();
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityExtension && !(bee = (BlockEntityExtension)blockEntity).minecolonies_compatibility$isUnloaded()) {
            this.view.unlink();
        }
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!super.onPartActivate(player, hand, pos) && !this.isClientSide()) {
            MenuOpener.open((MenuType)((MenuType)ModuleMenuTypes.CITIZEN_TERMINAL.get()), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.view.onTick();
        return TickRateModulation.SAME;
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        if (newWatcher != null) {
            newWatcher.reset();
            newWatcher.setWatchAll(true);
            this.counter.clear();
            this.getMainNode().ifPresent(grid -> {
                KeyCounter original = grid.getStorageService().getCachedInventory();
                for (Object2LongMap.Entry entry : original) {
                    Object patt5368$temp = entry.getKey();
                    if (!(patt5368$temp instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)patt5368$temp;
                    this.counter.add((AEKey)itemKey, entry.getLongValue());
                }
            });
        }
    }

    public static ItemStack toStack(Object2LongMap.Entry<AEKey> entry) {
        return CitizenTerminalPart.toStack((AEItemKey)entry.getKey(), entry.getLongValue());
    }

    public static ItemStack toStack(AEItemKey key, long amount) {
        return key.toStack((int)Math.min(Integer.MAX_VALUE, amount));
    }

    public void onStackChange(AEKey what, long amount) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            this.getMainNode().ifPresent(grid -> {
                long prev = this.counter.get((AEKey)itemKey);
                this.counter.set((AEKey)itemKey, amount);
                if (prev < amount) {
                    this.view.enqueue(CitizenTerminalPart.toStack(itemKey, amount));
                }
            });
        }
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.view.read(data.m_128469_(TAG_LINK));
        this.config.readFromNBT(data.m_128469_("config"));
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128365_(TAG_LINK, (Tag)this.view.write());
        CompoundTag configTag = new CompoundTag();
        this.config.writeToNBT(configTag);
        data.m_128365_("config", (Tag)configTag);
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        boolean changed = this.view.read(data);
        return needRedraw || changed;
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.view.write(data);
    }

    @NotNull
    public INetworkStorageView getView() {
        return this.view;
    }

    public IConfigManager getConfigManager() {
        return this.config;
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenTerminalPart.this.getLevel();
        }

        @Override
        public BlockPos getPos() {
            return CitizenTerminalPart.this.getBlockEntity().m_58899_();
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return CitizenTerminalPart.this.getSide();
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)CitizenTerminalPart.this.getPartItem());
        }

        @Override
        public boolean isActive() {
            return CitizenTerminalPart.this.isActive();
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            IPartHost host = CitizenTerminalPart.this.getHost();
            if (host != null) {
                host.markForSave();
                host.markForUpdate();
            }
        }

        @Override
        public void unlink() {
            super.unlink();
            IPartHost host = CitizenTerminalPart.this.getHost();
            if (host != null) {
                host.markForSave();
                host.markForUpdate();
            }
        }

        @Override
        public boolean canExtract() {
            return CitizenTerminalPart.this.hasPermission() && ((AccessRestriction)CitizenTerminalPart.this.config.getSetting(Settings.ACCESS)).isAllowExtraction();
        }

        @Override
        public boolean canInsert() {
            return CitizenTerminalPart.this.hasPermission() && ((AccessRestriction)CitizenTerminalPart.this.config.getSetting(Settings.ACCESS)).isAllowInsertion();
        }

        @Override
        public Stream<ItemStack> getAllStacks() {
            return StreamSupport.stream(CitizenTerminalPart.this.counter.spliterator(), false).map(CitizenTerminalPart::toStack);
        }

        @Override
        public ItemStack extractItem(ItemStack stack, boolean simulate) {
            IGrid grid = CitizenTerminalPart.this.getMainNode().getGrid();
            if (grid == null) {
                return ItemStack.f_41583_;
            }
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            MEStorage network = grid.getStorageService().getInventory();
            int extractingCount = (int)network.extract((AEKey)key, (long)stack.m_41613_(), Actionable.ofSimulate((boolean)simulate), CitizenTerminalPart.this.action);
            if (extractingCount == 0) {
                return ItemStack.f_41583_;
            }
            return key.toStack(extractingCount);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            IGrid grid = CitizenTerminalPart.this.getMainNode().getGrid();
            if (grid == null) {
                return ItemStack.f_41583_;
            }
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            MEStorage network = grid.getStorageService().getInventory();
            int insertedCount = (int)network.insert((AEKey)key, (long)stack.m_41613_(), Actionable.ofSimulate((boolean)simulate), CitizenTerminalPart.this.action);
            if (insertedCount == 0) {
                return stack;
            }
            stack = stack.m_41777_();
            stack.m_41774_(insertedCount);
            return stack;
        }
    }
}

