/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common;

import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;

public class OptionalModule<MODULE extends AbstractModule> {
    private final String modId;
    private final Supplier<Supplier<MODULE>> initializer;
    private boolean isLoaded;
    private MODULE module;

    public OptionalModule(String modid, Supplier<Supplier<MODULE>> initializer) {
        this.modId = modid;
        this.initializer = initializer;
        this.isLoaded = false;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isInstalled() {
        return ModList.get().isLoaded(this.getModId());
    }

    protected boolean canLoad() {
        return this.isInstalled();
    }

    public void tryLoad() {
        if (this.canLoad()) {
            this.isLoaded = true;
            this.module = (AbstractModule)this.initializer.get().get();
            ((AbstractModule)this.module).onLoad();
            IEventBus fml_bus = FMLJavaModLoadingContext.get().getModEventBus();
            fml_bus.addListener(arg_0 -> this.module.onFMLCommonSetup(arg_0));
            fml_bus.addListener(arg_0 -> this.module.onFMLClientSetup(arg_0));
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public MODULE getModule() {
        return this.module;
    }
}

