/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.jei;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import steve_gall.minecolonies_compatibility.api.client.jei.GhostIngredientHandler;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherableIconCache;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.FruitIconCache;
import steve_gall.minecolonies_compatibility.core.client.gui.SmithingTeachScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.StonecutterTeachScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.init.ModJobs;
import steve_gall.minecolonies_compatibility.module.client.jei.BucketFillingTeachRecipeTransferHandler;
import steve_gall.minecolonies_compatibility.module.client.jei.ButcherCategory;
import steve_gall.minecolonies_compatibility.module.client.jei.ModJeiRecipeTypes;
import steve_gall.minecolonies_compatibility.module.client.jei.OrchardistCategory;
import steve_gall.minecolonies_compatibility.module.client.jei.ResearchCategory;
import steve_gall.minecolonies_compatibility.module.client.jei.SmithingTeachRecipeTransferHandler;
import steve_gall.minecolonies_compatibility.module.client.jei.StonecutterTeachRecipeTransferHandler;

@JeiPlugin
public class ModPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ResearchCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OrchardistCategory(((JobEntry)ModJobs.ORCHARDIST.get()).produceJob(null), ModJeiRecipeTypes.ORCHARDIST_FRUIT, guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ButcherCategory(((JobEntry)ModJobs.BUTCHER.get()).produceJob(null), ModJeiRecipeTypes.BUTCHER_BUTCHERABLE, guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(ModJeiRecipeTypes.RESEARCH, this.getGlobalResearches().map(ResearchCategory.ResearchCache::new).toList());
        registration.addRecipes(ModJeiRecipeTypes.ORCHARDIST_FRUIT, CustomizedFruit.getRegistry().values().stream().map(FruitIconCache::new).toList());
        registration.addRecipes(ModJeiRecipeTypes.BUTCHER_BUTCHERABLE, CustomizedButcherable.getRegistry().values().stream().map(ButcherableIconCache::new).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.blockHutUniversity), new RecipeType[]{ModJeiRecipeTypes.RESEARCH});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(TeachRecipeScreen.class, new GhostIngredientHandler());
        registration.addRecipeClickArea(SmithingTeachScreen.class, 68, 49, 22, 15, new RecipeType[]{RecipeTypes.SMITHING});
        registration.addRecipeClickArea(StonecutterTeachScreen.class, 77, 36, 22, 15, new RecipeType[]{RecipeTypes.STONECUTTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        RecipeType<IGenericRecipe> recipeType = ModPlugin.createRecipeType((JobEntry)ModJobs.FLUID_MANAGER.get());
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BucketFillingTeachRecipeTransferHandler(transferHelper, recipeType), recipeType);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new SmithingTeachRecipeTransferHandler(transferHelper), RecipeTypes.SMITHING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new StonecutterTeachRecipeTransferHandler(transferHelper), RecipeTypes.STONECUTTING);
    }

    public Stream<IGlobalResearch> getGlobalResearches() {
        IGlobalResearchTree api = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree();
        return api.getBranches().stream().flatMap(branchId -> api.getPrimaryResearch(branchId).stream()).flatMap(this::getGlobalResearches);
    }

    public Stream<IGlobalResearch> getGlobalResearches(ResourceLocation researchId) {
        IGlobalResearchTree api = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree();
        IGlobalResearch research = api.getResearch(researchId);
        return Stream.concat(Stream.of(research), research.getChildren().stream().flatMap(this::getGlobalResearches));
    }

    public static RecipeType<IGenericRecipe> createRecipeType(JobEntry jobEntry) {
        ResourceLocation uid = jobEntry.getKey();
        return RecipeType.create((String)uid.m_135827_(), (String)uid.m_135815_(), IGenericRecipe.class);
    }

    public ResourceLocation getPluginUid() {
        return MineColoniesCompatibility.rl("plugin");
    }
}

