/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IBooleanConditionSupplier;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBlacksmith;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.colony.jobs.JobBlacksmith;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.ai.workers.crafting.EntityAIWorkBlacksmith;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import java.io.Serializable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.AIInterruptEventTarget;
import steve_gall.minecolonies_compatibility.api.common.repair.CustomizedRepair;
import steve_gall.minecolonies_compatibility.api.common.repair.EntityContext;
import steve_gall.minecolonies_compatibility.api.common.repair.RepairTransaction;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AIRepairState;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.mixin.common.minecolonies.AbstractEntityAICraftingAccessor;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;

@Mixin(value={EntityAIWorkBlacksmith.class})
public abstract class EntityAIWorkBlacksmithMixin
extends AbstractEntityAICrafting<JobBlacksmith, BuildingBlacksmith> {
    @Unique
    private RepairTransaction minecolonies_compatibility$transaction;
    @Unique
    private int minecolonies_compatibility$hitCount;

    public EntityAIWorkBlacksmithMixin(@NotNull JobBlacksmith job) {
        super((AbstractJobCrafter)job);
    }

    @Inject(method={"<init>"}, remap=false, at={@At(value="TAIL")}, cancellable=false)
    private void init(JobBlacksmith blacksmith, CallbackInfo ci) {
        if (ModuleManager.TCONSTRUCT.isLoaded()) {
            this.registerTarget(new AIInterruptEventTarget((IBooleanConditionSupplier & Serializable)() -> {
                IAIState state = this.getState();
                return state == AIWorkerState.IDLE || state == AIWorkerState.START_WORKING;
            }, this::checkRepairableItem, 20));
            this.registerTarget((TickingTransition)new AITarget((IState)AIRepairState.REPAIR, this::repair, 10));
        }
    }

    private IAIState checkRepairableItem() {
        if (!((Boolean)((BuildingBlacksmith)this.building).getSettingValueOrDefault(ModBuildingModules.REPAIR_ITEM, (Object)false)).booleanValue()) {
            return null;
        }
        EntityContext context = new EntityContext((EntityAIWorkBlacksmith)this, this.worker);
        for (CustomizedRepair repair : CustomizedRepair.getRegistry().values()) {
            CustomizedRepair.CheckResult result = repair.check(context);
            if (result == null) continue;
            if (result.transaction != null) {
                this.minecolonies_compatibility$transaction = result.transaction;
                this.minecolonies_compatibility$hitCount = 0;
                return AIRepairState.REPAIR;
            }
            if (result.needsCurrently == null) continue;
            this.needsCurrently = result.needsCurrently;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return null;
    }

    private IAIState repair() {
        if (this.minecolonies_compatibility$transaction == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        EntityContext context = new EntityContext((EntityAIWorkBlacksmith)this, this.worker);
        if (!this.minecolonies_compatibility$transaction.onHitting(context)) {
            return this.onHitComplete(context, null);
        }
        ++this.minecolonies_compatibility$hitCount;
        ItemStack mainHeld = this.worker.m_21205_();
        this.hitBlockWithToolInHand(((BuildingBlacksmith)this.building).getPosition());
        if (!mainHeld.m_41619_()) {
            Network.getNetwork().sendToTrackingEntity((IMessage)new LocalizedParticleEffectMessage(mainHeld, ((BuildingBlacksmith)this.building).getPosition().m_7494_()), (Entity)this.worker);
        }
        if (this.minecolonies_compatibility$hitCount >= ((AbstractEntityAICraftingAccessor)((Object)this)).invokeGetRequiredProgressForMakingRawMaterial()) {
            RepairTransaction.RepairResult result = this.minecolonies_compatibility$transaction.onHitComplete(context);
            return this.onHitComplete(context, result);
        }
        return this.getState();
    }

    private IAIState onHitComplete(EntityContext context, RepairTransaction.RepairResult result) {
        if (result != null) {
            if (result.state == RepairTransaction.RepairResult.State.NEXT) {
                if (result.next != null) {
                    this.worker.decreaseSaturationForContinuousAction();
                    this.minecolonies_compatibility$transaction = result.next;
                    this.minecolonies_compatibility$hitCount = 0;
                }
                return this.getState();
            }
            if (result.state == RepairTransaction.RepairResult.State.COMPLETED) {
                context.setHands(-1, -1);
                this.incrementActionsDoneAndDecSaturation();
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
                this.minecolonies_compatibility$transaction = null;
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        context.setHands(-1, -1);
        this.minecolonies_compatibility$transaction = null;
        return AIWorkerState.START_WORKING;
    }
}

