/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_compatibility.api.common.inventory.IFluidGhostMenu;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;

public class JEIGhostAcceptFluidMessage
extends AbstractMessage {
    private final int slotNumber;
    private final FluidStack stack;

    public JEIGhostAcceptFluidMessage(int slotNumber, FluidStack stack) {
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public JEIGhostAcceptFluidMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.slotNumber = buffer.readInt();
        this.stack = buffer.readFluidStack();
    }

    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.slotNumber);
        buffer.writeFluidStack(this.stack);
    }

    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof IFluidGhostMenu) {
            IFluidGhostMenu ghostMenu = (IFluidGhostMenu)abstractContainerMenu;
            ghostMenu.onGhostAcceptFluid(this.slotNumber, this.stack);
        }
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public FluidStack getStack() {
        return this.stack;
    }
}

