/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import it.unimi.dsi.fastutil.objects.AbstractObject2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;

public class ItemStackCounter {
    private final Object2LongMap<ItemStackKey> counter = new Object2LongOpenHashMap();
    private final List<CountChangedListener> listeners = new ArrayList<CountChangedListener>();

    public void deserializeTag(CompoundTag tag) {
        this.replace(NBTUtils2.deserializeList(tag, "counter", t -> {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)t.m_128469_("item"));
            long count = t.m_128454_("count");
            return new AbstractObject2LongMap.BasicEntry((Object)new ItemStackKey(stack), count);
        }));
    }

    public CompoundTag serializeTag() {
        CompoundTag tag = new CompoundTag();
        NBTUtils2.serializeCollection(tag, "counter", this.entrySet(), entry -> {
            CompoundTag t = new CompoundTag();
            t.m_128365_("item", (Tag)((ItemStackKey)entry.getKey()).getStack(1).serializeNBT());
            t.m_128356_("count", entry.getLongValue());
            return t;
        });
        return tag;
    }

    public void deserializeBuffer(FriendlyByteBuf buffer) {
        this.replace(buffer.m_236845_(b -> {
            ItemStack stack = b.m_130267_();
            long count = b.readLong();
            return new AbstractObject2LongMap.BasicEntry((Object)new ItemStackKey(stack), count);
        }));
    }

    public void serializeBuffer(FriendlyByteBuf buffer) {
        buffer.m_236828_(this.entrySet(), (b, entry) -> {
            b.m_130055_(((ItemStackKey)entry.getKey()).getStack(1));
            b.writeLong(entry.getLongValue());
        });
    }

    public void replace(Iterable<Object2LongMap.Entry<ItemStackKey>> from) {
        HashSet<ItemStackKey> prevKeys = new HashSet<ItemStackKey>((Collection<ItemStackKey>)this.keySet());
        for (Object2LongMap.Entry<ItemStackKey> entry : from) {
            ItemStackKey key2 = (ItemStackKey)entry.getKey();
            this.set(key2, entry.getLongValue());
            prevKeys.remove(key2);
        }
        prevKeys.forEach(key -> this.set((ItemStackKey)key, 0L));
    }

    public long get(ItemStackKey key) {
        return this.counter.getOrDefault((Object)key, 0L);
    }

    public long set(ItemStackKey key, long count) {
        long old;
        long l2 = old = (count = Math.max(0L, count)) <= 0L ? this.counter.removeLong((Object)key) : this.counter.put((Object)key, count);
        if (old != count) {
            long c = count;
            this.listeners.forEach(l -> l.onItemCountChanged(key, old, c));
        }
        return old;
    }

    public long extract(ItemStackKey key, long count) {
        long old = this.get(key);
        return this.set(key, old - count);
    }

    public long insert(ItemStackKey key, long count) {
        long old = this.get(key);
        return this.set(key, old + count);
    }

    public ObjectSet<ItemStackKey> keySet() {
        return this.counter.keySet();
    }

    public ObjectSet<Object2LongMap.Entry<ItemStackKey>> entrySet() {
        return this.counter.object2LongEntrySet();
    }

    public void addListener(CountChangedListener listener) {
        this.listeners.add(listener);
    }

    @FunctionalInterface
    public static interface CountChangedListener {
        public void onItemCountChanged(ItemStackKey var1, long var2, long var4);
    }
}

