/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CombinedItemHandler
implements IItemHandler {
    private final IItemHandler[] handlers;
    private final int[] offsets;
    private final int slots;

    public CombinedItemHandler(IItemHandler[] handlers) {
        int offset = 0;
        this.handlers = new IItemHandler[handlers.length];
        this.offsets = new int[handlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            IItemHandler handler;
            this.handlers[i] = handler = handlers[i];
            this.offsets[i] = offset;
            offset += handler.getSlots();
        }
        this.slots = offset;
    }

    public int getSlots() {
        return this.slots;
    }

    private int getHandlerIndex(int slot) {
        if (0 <= slot && slot < this.slots) {
            for (int i = 0; i < this.offsets.length; ++i) {
                if (slot >= this.offsets[i]) continue;
                return i - 1;
            }
            return this.offsets.length - 1;
        }
        return -1;
    }

    public InternalHandlerInfo getInternalHandler(int slot) {
        int handlerIndex = this.getHandlerIndex(slot);
        return handlerIndex == -1 ? null : new InternalHandlerInfo(this.handlers[handlerIndex], slot - this.offsets[handlerIndex]);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        InternalHandlerInfo internal = this.getInternalHandler(slot);
        return internal == null ? ItemStack.f_41583_ : internal.getStackInSlot();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        InternalHandlerInfo internal = this.getInternalHandler(slot);
        return internal == null ? stack : internal.insertItem(stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        InternalHandlerInfo internal = this.getInternalHandler(slot);
        return internal == null ? ItemStack.f_41583_ : internal.extractItem(amount, simulate);
    }

    public int getSlotLimit(int slot) {
        InternalHandlerInfo internal = this.getInternalHandler(slot);
        return internal == null ? 0 : internal.getSlotLimit();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        InternalHandlerInfo internal = this.getInternalHandler(slot);
        return internal == null ? false : internal.isItemValid(stack);
    }

    public record InternalHandlerInfo(IItemHandler handler, int slot) {
        @NotNull
        public ItemStack getStackInSlot() {
            return this.handler.getStackInSlot(this.slot);
        }

        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            return this.handler.insertItem(this.slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int amount, boolean simulate) {
            return this.handler.extractItem(this.slot, amount, simulate);
        }

        public int getSlotLimit() {
            return this.handler.getSlotLimit(this.slot);
        }

        public boolean isItemValid(@NotNull ItemStack stack) {
            return this.handler.isItemValid(this.slot, stack);
        }
    }
}

