/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.guard;

import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableEntityAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizableAISimpleGuard;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGuard;

public class GunnerCombatAI<T extends AbstractEntityAIGuard<J, B>, J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends CustomizableAISimpleGuard<T, J, B> {
    public static final int FLEE_CHANCE = 3;
    private static final VisibleCitizenStatus ARCHER_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_combat.png"), "com.minecolonies.gui.visiblestatus.archer_combat");
    private final PathingOptions combatPathingOptions = new PathingOptions();

    public GunnerCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, T parentAI) {
        super(owner, stateMachine, parentAI);
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(1.5);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        super.doAttack(target);
        this.tryFlee(target);
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(ARCHER_COMBAT);
    }

    public void tryFlee(LivingEntity target) {
        EntityCitizen user = (EntityCitizen)this.user;
        if (user.m_20280_((Entity)target) < 7.0) {
            Object parentAI;
            CustomizedAI customizedAI;
            if (user.m_217043_().m_188503_(3) == 0 && !((AbstractBuildingGuards)user.getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard") && (customizedAI = ((ICustomizableEntityAI)(parentAI = this.getParentAI())).getSelectedAI()) instanceof CustomizedAIGuard) {
                CustomizedAIGuard guard = (CustomizedAIGuard)customizedAI;
                double speed = guard.getJobPathSpeed((AbstractEntityCitizen)user);
                EntityNavigationUtils.walkAwayFrom((AbstractFastMinecoloniesEntity)user, (BlockPos)target.m_20183_(), (int)((int)(this.getAttackDistance() / 2.0)), (double)speed);
            }
        } else {
            user.getNavigation().m_26573_();
        }
    }

    @Override
    @Nullable
    public PathResult<?> createPathResult(LivingEntity target, double speed) {
        AbstractPathJob job = this.createPathJob(target, (EntityCitizen)this.user);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, speed, true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    private AbstractPathJob createPathJob(LivingEntity target, EntityCitizen user) {
        Level level = user.m_9236_();
        BlockPos userPos = user.m_20183_();
        BlockPos targetPos = target.m_20183_();
        if ((double)BlockPosUtil.getDistanceSquared((BlockPos)targetPos, (BlockPos)userPos) <= 4.0) {
            return new PathJobMoveAwayFromLocation(level, PathfindingUtils.prepareStart((LivingEntity)target), targetPos, 7, (int)user.m_21051_(Attributes.f_22277_).m_22135_(), (Mob)user);
        }
        if ((double)BlockPosUtil.getDistance2D((BlockPos)targetPos, (BlockPos)userPos) >= 20.0) {
            return new PathJobMoveToLocation(level, PathfindingUtils.prepareStart((LivingEntity)user), targetPos, 200, (Mob)user);
        }
        return new PathJobCanSee((Mob)user, target, level, ((AbstractBuildingGuards)user.getCitizenData().getWorkBuilding()).getGuardPos((AbstractEntityCitizen)user), 40);
    }
}

