/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class StonecutterRecipeStorage
implements ICustomizedRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("stonecutting");
    public static final String TAG_RECIPE_ID = "recipeId";
    public static final String TAG_INGREDIENT = "ingredient";
    public static final String TAG_RESULT = "result";
    private final ResourceLocation recipeId;
    private final ItemStorage ingredient;
    private final ItemStack result;
    private final List<ItemStorage> input;

    public static void serialize(IFactoryController controller, CompoundTag tag, StonecutterRecipeStorage recipe) {
        tag.m_128359_(TAG_RECIPE_ID, recipe.recipeId.toString());
        tag.m_128365_(TAG_INGREDIENT, (Tag)controller.serialize((Object)recipe.ingredient));
        tag.m_128365_(TAG_RESULT, (Tag)recipe.result.serializeNBT());
    }

    public static StonecutterRecipeStorage deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_(TAG_RECIPE_ID));
        ItemStorage ingredient = (ItemStorage)controller.deserialize(tag.m_128469_(TAG_INGREDIENT));
        ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RESULT));
        return new StonecutterRecipeStorage(recipeId, ingredient, result);
    }

    public StonecutterRecipeStorage(ResourceLocation recipeId, ItemStorage ingredient, ItemStack result) {
        this.recipeId = recipeId;
        this.ingredient = ingredient;
        this.result = result;
        this.input = Collections.singletonList(ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingredient, this.result.m_41720_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StonecutterRecipeStorage) {
            StonecutterRecipeStorage other = (StonecutterRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingredient.equals((Object)other.ingredient) && ItemStackHelper.equals(this.result, other.result);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public ItemStorage getIngredient() {
        return this.ingredient;
    }

    public List<ItemStorage> getInput() {
        return this.input;
    }

    public int getGridSize() {
        return 1;
    }

    public ItemStack getPrimaryOutput() {
        return this.result;
    }

    public List<ItemStack> getAlternateOutputs() {
        return Collections.emptyList();
    }

    public List<ItemStack> getSecondaryOutputs() {
        return Collections.emptyList();
    }

    public Block getIntermediate() {
        return Blocks.f_50016_;
    }

    public ResourceLocation getRecipeSource() {
        return null;
    }

    public ResourceLocation getRecipeType() {
        return null;
    }

    public ResourceLocation getLootTable() {
        return null;
    }

    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

