/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalHerdingLootGenericRecipe
implements IGenericRecipe {
    private final EntityType<?> entityType;
    private final ResourceLocation entityTypeKey;
    private final ResourceLocation lootTable;
    private final List<List<ItemStack>> breedingItems;
    private final EquipmentTypeEntry toolType;

    public AnimalHerdingLootGenericRecipe(EntityType<?> entityType, List<List<ItemStorage>> breedingItems, ResourceLocation lootTable, EquipmentTypeEntry toolType) {
        this.entityType = entityType;
        this.entityTypeKey = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        this.lootTable = lootTable;
        this.breedingItems = breedingItems.stream().map(l -> l.stream().map(ItemStorage::getItemStack).toList()).toList();
        this.toolType = toolType;
    }

    public int getGridSize() {
        return 0;
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return this.entityTypeKey;
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return ItemStack.f_41583_;
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return Collections.emptyList();
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return Collections.emptyList();
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.breedingItems;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return Blocks.f_50016_;
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.toolType;
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return this.entityType;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return 0;
    }
}

