/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import steve_gall.minecolonies_compatibility.api.common.building.module.ICraftingModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.core.common.init.ModInteractions;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModulePos;

public class WorkingBlockInteraction
extends ServerCitizenInteraction {
    private static final Tuple<Component, Component>[] tuples = new Tuple[]{new Tuple((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.okay"), null), new Tuple((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.ignore"), null), new Tuple((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.remindmelater"), null), new Tuple((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.skipchitchat"), null)};
    private ModulePos modulePos;
    private IToken<?> recipeId;
    private IToken<?> requestId;

    public WorkingBlockInteraction(IChatPriority priority, ICraftingModuleWithExternalWorkingBlocks module, IRecipeStorage recipeStorage, IRequest<? extends PublicCrafting> request) {
        super(module.getWorkingBlockNotFoundMessage(recipeStorage), true, priority, null, (Component)Component.m_237119_(), tuples);
        this.modulePos = new ModulePos((IBuildingModule)module);
        this.recipeId = recipeStorage.getToken();
        this.requestId = request.getId();
    }

    public WorkingBlockInteraction(ICitizen citizen) {
        super(citizen);
        this.modulePos = null;
        this.recipeId = null;
        this.requestId = null;
    }

    public boolean isValid(ICitizenData citizen) {
        IBuildingModule iBuildingModule = this.modulePos.getModule();
        if (iBuildingModule instanceof ICraftingModuleWithExternalWorkingBlocks) {
            ICraftingModuleWithExternalWorkingBlocks module = (ICraftingModuleWithExternalWorkingBlocks)iBuildingModule;
            if (module.getBuilding().getColony().getRequestManager().getRequestForToken(this.requestId) == null) {
                return false;
            }
            IRecipeStorage recipe = IMinecoloniesAPI.getInstance().getColonyManager().getRecipeManager().getRecipe(this.recipeId);
            if (recipe != null) {
                BlockPos pos = module.getRecipeWorkingBlocks(recipe).findAny().orElse(null);
                return pos == null;
            }
        }
        return false;
    }

    protected void loadValidator() {
    }

    public CompoundTag serializeNBT() {
        StandardFactoryController controller = StandardFactoryController.getInstance();
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("modulePos", (Tag)this.modulePos.serializeNBT());
        tag.m_128365_("recipeId", (Tag)controller.serialize(this.recipeId));
        tag.m_128365_("requestId", (Tag)controller.serialize(this.requestId));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        StandardFactoryController controller = StandardFactoryController.getInstance();
        super.deserializeNBT(tag);
        this.modulePos = new ModulePos(tag.m_128469_("modulePos"));
        this.recipeId = (IToken)controller.deserialize(tag.m_128469_("recipeId"));
        this.requestId = (IToken)controller.deserialize(tag.m_128469_("requestId"));
    }

    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    public String getType() {
        return ModInteractions.WORKING_BLOCK.getId().m_135815_();
    }

    public ModulePos getModulePos() {
        return this.modulePos;
    }

    public IToken<?> getRecipeId() {
        return this.recipeId;
    }

    public IToken<?> getRequestId() {
        return this.requestId;
    }
}

