/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModule;

public abstract class RestrictableModule
extends AbstractBuildingModule
implements IRestrictableModule,
IPersistentModule {
    public static final String TAG_RESTRICT_ENABLED = "restrict_enabled";
    public static final String TAG_RESTRICT_POS_1 = "restrict_pos1";
    public static final String TAG_RESTRICT_POS_2 = "restrict_pos2";
    private boolean restrictEnabled = false;
    @Nullable
    private BlockPos restrictPos1 = null;
    @Nullable
    private BlockPos restrictPos2 = null;

    @Override
    public void setRestrictEnabled(boolean enabled) {
        this.restrictEnabled = enabled;
        this.markDirty();
    }

    @Override
    public boolean isRestrictEnabled() {
        return this.restrictEnabled;
    }

    @Override
    public void setRestrictArea(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        this.restrictPos1 = pos1;
        this.restrictPos2 = pos2;
        this.setRestrictEnabled(true);
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos1() {
        BlockPos pos1 = this.restrictPos1;
        return pos1 != null ? pos1 : this.building.getPosition();
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos2() {
        BlockPos pos2 = this.restrictPos2;
        return pos2 != null ? pos2 : this.building.getPosition();
    }

    public void deserializeNBT(CompoundTag compound) {
        this.restrictEnabled = compound.m_128471_(TAG_RESTRICT_ENABLED);
        if (compound.m_128441_(TAG_RESTRICT_POS_1)) {
            this.restrictPos1 = BlockPosUtil.read((CompoundTag)compound, (String)TAG_RESTRICT_POS_1);
        }
        if (compound.m_128441_(TAG_RESTRICT_POS_2)) {
            this.restrictPos2 = BlockPosUtil.read((CompoundTag)compound, (String)TAG_RESTRICT_POS_2);
        }
    }

    public void serializeNBT(CompoundTag compound) {
        compound.m_128379_(TAG_RESTRICT_ENABLED, this.restrictEnabled);
        if (this.restrictPos1 != null) {
            BlockPosUtil.write((CompoundTag)compound, (String)TAG_RESTRICT_POS_1, (BlockPos)this.restrictPos1);
        }
        if (this.restrictPos2 != null) {
            BlockPosUtil.write((CompoundTag)compound, (String)TAG_RESTRICT_POS_2, (BlockPos)this.restrictPos2);
        }
    }

    public void serializeToView(FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.restrictEnabled);
        buf.m_236821_((Object)this.restrictPos1, FriendlyByteBuf::m_130064_);
        buf.m_236821_((Object)this.restrictPos2, FriendlyByteBuf::m_130064_);
    }
}

